package com.anf.gestion.client.files;

import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;

import com.anf.gestion.client.files.model.DownloadFileRequest;
import com.anf.gestion.client.files.model.DownloadFileResponse;
import com.anf.gestion.client.files.model.ListFilesRequest;
import com.anf.gestion.client.files.model.ListFilesResponse;
import com.anf.gestion.client.files.model.UploadFileRequest;
import com.anf.oauth.client.AbstractClient;
import com.anf.oauth.json.BasicResponse;

public class FilesClient extends AbstractClient{

	public FilesClient(String url, int timeout) {
		super(url, timeout);
	}

	public ListFilesResponse listFiles(ListFilesRequest request) throws IOException {

		AtomicReference<ListFilesResponse> resp = handleJsonRequest("/files/list",request, ListFilesResponse.class);
		return resp.get();
	}

	public DownloadFileResponse downloadFile(DownloadFileRequest request) throws IOException {
		AtomicReference<DownloadFileResponse> resp = handleJsonRequest("/files/download",request, DownloadFileResponse.class);
		return resp.get();
	}

	public BasicResponse uploadFile(UploadFileRequest request) throws IOException {
		AtomicReference<BasicResponse> resp = handleJsonRequest("/files/upload",request, BasicResponse.class);
		return resp.get();
	}

	public BasicResponse uploadFileBinary(String localizator,String fileName,File file,int docType) throws IOException {
		Path path = Paths.get(file.getCanonicalPath());
		byte[] content = Files.readAllBytes(path);
		String contentType = Files.probeContentType(path);
		if(fileName==null)
			fileName=file.getName();
		return uploadFileBinary(localizator, fileName, content, contentType, docType);
	}

	public BasicResponse uploadFileBinary(String localizator, String fileName, byte[] content, String contentType,
			int docType) throws IOException {
		BasicResponse resp=new BasicResponse();
		Map<String, String> headers=new TreeMap<>();
		headers.put("Authorization", getBearerHeader());
		headers.put("localizator", localizator);
		headers.put("filename",URLEncoder.encode(fileName,StandardCharsets.UTF_8));
		headers.put("Content-type", contentType);
		headers.put("docType", docType+"");
		
		try {
			handleRawRequest("/files/upload/binary", "POST", content, headers);
			resp.setSuccess(true);
		} catch (Exception e) {
			resp.setError(e.getMessage());
		}
		
		return resp;
		
	}
	
	public BasicResponse uploadFilesZipped(String localizator, byte[] zipContent, int docType) throws IOException {
		BasicResponse resp=new BasicResponse();
		Map<String, String> headers=new TreeMap<>();
		headers.put("Authorization", getBearerHeader());
		headers.put("localizator", localizator);
		headers.put("Content-type", "application/zip");
		headers.put("docType", docType+"");
		
		try {
			handleRawRequest("/files/upload/zipped", "POST", zipContent, headers);
			resp.setSuccess(true);
		} catch (Exception e) {
			resp.setError(e.getMessage());
		}
		return resp;
		
	}
	

	public byte[] downloadFileName(String localizator, String name) throws IOException {

		Map<String, String> headers=new TreeMap<>();
		headers.put("Authorization", getBearerHeader());
		headers.put("localizator", localizator);
		headers.put("name", name);
		
		return handleRawRequest("/files/download-name", "POST", null, headers);		
		
	}
	
	public boolean existsFile(String localizator, String name) throws IOException {

		Map<String, String> headers=new TreeMap<>();
		headers.put("Authorization", getBearerHeader());
		headers.put("localizator", localizator);
		headers.put("name", name);
		
		try {
			handleRawRequest("/files/exists-file", "POST", null, headers);
			return true;
		} catch (IOException e1) {			
			return false;
		}			
	}
}
