/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.anf.ws.ar.xml.validator;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;

import org.xml.sax.SAXException;

/**
 *
 * @author ANFP-05
 */
public class ValidadorXsd {

	public Boolean validarFormatoXmlAtributos(File xml) throws IOException, SAXException{
		boolean exito = false;
		String pathtotal = "com/anf/ws/ar/xml/validator/formularioAtributos.xsd";
		exito = ValidadorXsd.this.validarComprobante(xml, pathtotal);
		return exito;
	}

	private boolean validarComprobante(File _comprobante, String _direccionXSD) throws IOException, SAXException {
		boolean exito = false;
		URL location = ClassLoader.getSystemClassLoader().getResource(_direccionXSD);
		//Instanciamos la fabrica de W3C XML Schema language.
		SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
		//Instanciamos el esquema a utilizar para validar.
		// File schemaLocation = new File(_direccionXSD);
		Schema schema = factory.newSchema(location);
		Validator validator = schema.newValidator();
		// creamos el objeto Source a validar a partir del file del comprobante
		Source source = new StreamSource(_comprobante);
		// validamos el docuemnto
		try {
			validator.validate(source);
			exito = true;
		} catch (SAXException ex) {
			exito = false;
		}
		return exito;
	}

}
