package com.anf.ws.ar.xml.types;

public enum CertificateType {

	PERSONA_FISICA(1) {
		@Override
		String valueOU() {
			return "Certificado de Clase 2 de Persona Fisica";
		}
		
	},
	OPERADOR_AR(2) {
		@Override
		String valueOU() {
			return "Certificado de Operador AR";
		}
		
	},
	OPERADOR_AR_2(3) {
		@Override
		String valueOU() {
			return "Certificado de Operador AR";
		}
		
	},
	REP_LEGAL_PJ(4) {
		@Override
		String valueOU() {
			return "Certificado de Representante Legal de Persona Juridica";
		}
		
	},
	REP_LEGAL_SIN_PJ(5){
		@Override
		String valueOU() {
			return "Certificado de Representante Legal de Entidad sin personalidad juridica";
		}
		
	},
	REP_LEGAL_ADMIN_UNICOS(6){
		@Override
		String valueOU() {
			return "Certificado de Representante Legal para Administradores unicos y solidarios";
		}
		
	},
	RDE(7) {
		@Override
		String valueOU() {
			return "Certificado de Responsable de Dictamenes de Emision";
		}
		
	},
	EMPLEADO_PUBLICO_ALTO(8){
		@Override
		String valueOU() {
			return "CERTIFICADO ELECTRÓNICO DE EMPLEADO PÚBLICO NIVEL ALTO";
		}
		
	},
	EMPLEADO_PUBLICO_MEDIO(9){
		@Override
		String valueOU() {
			return "CERTIFICADO ELECTRÓNICO DE EMPLEADO PÚBLICO NIVEL MEDIO";
		}		
	},
	OPERADOR_PKI(10){
		@Override
		String valueOU() {
			return "Certificado de Operador PKI";
		}		
	},
	PERSONA_FISICA_CORP(11) {
		@Override
		String valueOU() {
			return "Certificado corporativo de Persona Fisica";
		}
		
	},
	OPERADOR_PKI_ADMIN(12){
		@Override
		String valueOU() {
			return "Certificado de Operador PKI ADMIN";
		}		
	},
	QSEALC(13){
		@Override
		String valueOU() {
			return "Certificado Cualificado de Sello Electrónico";
		}		
	},
	QSEALC_PSD2(14){
		@Override
		String valueOU() {
			return "Certificado Cualificado de Sello Electrónico PSD2";
		}		
	},
	QSEALC_AP_MEDIO(15){
		@Override
		String valueOU() {
			return "Certificado Cualificado de Sello Electrónico AA.PP. Nivel Medio";
		}		
	},
	QSEALC_AP_ALTO(16){
		@Override
		String valueOU() {
			return "Certificado Cualificado de Sello Electrónico AA.PP. Nivel Alto";
		}		
	},
	PERSONA_NATURAL_EC(17){
		@Override
		String valueOU() {
			return null;
		}		
	},
	MIEMBRO_EMPRESA_EC(18){
		@Override
		String valueOU() {
			return null;
		}		
	},
	REP_LEGAL_EC(19){
		@Override
		String valueOU() {
			return null;
		}		
	},
	SELLO_ELECTRONICO_EC(20){
		@Override
		String valueOU() {
			return null;
		}		
	},
	CORPORATIVO_COLEGIADO(21) {
		@Override
		String valueOU() {
			return "Certificado Corporativo de Colegiado";
		}
		
	},
	;
	
	int value=-1;
	private CertificateType(int value) {
		this.value=value;
	}
	abstract String valueOU();
	
	public int value() {
		return value;
	}
	
	@Override
	public String toString() {
		return valueOU();
	}
	
	
	public static CertificateType getValue(Integer tipoCertificado) {
		CertificateType[] values = values();
		for (int i = 0; i < values.length; i++) {
			if(values[i].value()==tipoCertificado)
				return values[i];
		}
		return null;
	}
	
	public boolean match(CertificateType... others) {
		if(others!=null  && others.length>0) {
			for (int i = 0; i < others.length; i++) {
				if(this==others[i])
					return true;
			}
		}
		return false;
	}
	
	public boolean requireOrgId() {
		return match(PERSONA_FISICA_CORP,
				REP_LEGAL_PJ,
				REP_LEGAL_SIN_PJ,
				REP_LEGAL_ADMIN_UNICOS,
				EMPLEADO_PUBLICO_ALTO,
				EMPLEADO_PUBLICO_MEDIO,
				PERSONA_NATURAL_EC,
				MIEMBRO_EMPRESA_EC,
				REP_LEGAL_EC,
				SELLO_ELECTRONICO_EC
				) || isSeal();
	}
	public boolean includeCountry() {
		return match(PERSONA_FISICA,
				PERSONA_FISICA_CORP,
				CORPORATIVO_COLEGIADO,
				REP_LEGAL_PJ,
				REP_LEGAL_SIN_PJ,
				REP_LEGAL_ADMIN_UNICOS,
				EMPLEADO_PUBLICO_ALTO,
				EMPLEADO_PUBLICO_MEDIO);
	}
	public boolean includeOidDNI() {
		return match(REP_LEGAL_PJ,
				REP_LEGAL_SIN_PJ,
				REP_LEGAL_ADMIN_UNICOS);
	}
	
	public boolean isSeal() {
		return match(QSEALC,QSEALC_AP_ALTO,QSEALC_AP_MEDIO,QSEALC_PSD2);
	}
	
}
