package com.anf.ws.ar.xml.subjaltnames.impl;

import java.util.List;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.style.BCStyle;

import com.anf.cryptotoken.oid.PolicyOID;
import com.anf.ra.xml.ApplicationForm.Applicant.Attributes.Attribute;
import com.anf.ws.ar.xml.model.SubjectAlternateName;
import com.anf.ws.ar.xml.service.params.XmlBuildParams;
import com.anf.ws.ar.xml.types.CertificateType;

public class QSealAPSubjAltNames extends QSealSubjAltNames{

	String apRoot="2.16.724.1.3.5.6";

	public QSealAPSubjAltNames(XmlBuildParams params, PolicyOID policy, List<Attribute> attributes) {
		super(params,policy,attributes);
	}

	@Override
	public List<SubjectAlternateName> build() {
		List<SubjectAlternateName> list=super.build();		

		CertificateType certType = params.getCertType();

		if(certType==CertificateType.QSEALC_AP_MEDIO)
			addSubjectAlternateNameOid(list, apRoot+".2.1", "SELLO ELECTRONICO DE NIVEL MEDIO");
		if(certType==CertificateType.QSEALC_AP_ALTO)
			addSubjectAlternateNameOid(list, apRoot+".1.1", "SELLO ELECTRONICO DE NIVEL ALTO");

		addAPAttributeSAN(list,".2.2",BCStyle.O,true);
		addAPAttributeSAN(list,".2.3",BCStyle.SERIALNUMBER,true);
		addAPAttributeSAN(list,".2.5",BCStyle.CN,true);
		addAPAttributeSAN(list,".2.6",BCStyle.GIVENNAME,true);
		addSurnames(list);

		addAPAttributeSAN(list,".2.9",BCStyle.EmailAddress,false);

		return list;
	}

	private void addSurnames(List<SubjectAlternateName> list) {
		String[] split=null;
		String surname = attribute(BCStyle.SURNAME.getId());
		if(surname!=null)
			split=surname.trim().split(" ");			
		lastName1=oidMap.get("10.2");
		if(lastName1==null && split!=null && split.length>0)
			lastName1=split[0];
		if(lastName1!=null)
			addSubjectAlternateNameOid(list, apRoot+".2.7", lastName1.toUpperCase());

		lastName2=oidMap.get("10.3");
		if(lastName2==null && split!=null && split.length>1)
			lastName2=split[1];
		if(lastName2!=null)
			addSubjectAlternateNameOid(list, apRoot+".2.8", lastName2.toUpperCase());
	}

	private void addAPAttributeSAN(List<SubjectAlternateName> list, String branchOid, ASN1ObjectIdentifier oid, boolean upperCase) {
		String value = attribute(oid.getId());
		if(value!=null)
			addSubjectAlternateNameOid(list, apRoot+branchOid, upperCase?value.toUpperCase():value);

	}

	protected void addSubjectAlternateNameOid(List<SubjectAlternateName> list, String oid, String value) {
		SubjectAlternateName subjectAlternateName = null;
		if(value!=null && !value.isEmpty()) {
			subjectAlternateName=new SubjectAlternateName(oid,value.trim());
			list.add(subjectAlternateName);
		}
	}
}
