package com.anf.ws.ar.xml.subjaltnames.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import org.bouncycastle.asn1.x500.style.BCStyle;

import com.anf.cryptotoken.oid.PolicyOID;
import com.anf.ra.xml.ApplicationForm.Applicant.Attributes.Attribute;
import com.anf.ws.ar.enums.IdentificationType;
import com.anf.ws.ar.xml.attributes.XmlAttributesReader;
import com.anf.ws.ar.xml.model.SubjectAlternateName;
import com.anf.ws.ar.xml.service.params.XmlBuildParams;
import com.anf.ws.ar.xml.subjaltnames.SubjAltNames;

public class BasicSubjAltNames implements SubjAltNames{
	
	protected XmlBuildParams params;
	
	protected XmlAttributesReader xmlInfo;	

	protected PolicyOID policy;

	protected Map<String, String> oidMap=new TreeMap<>();
	
	protected IdentificationType identificationType=IdentificationType.FISICA;
	
	protected String lastName1,lastName2;
	
	protected List<Attribute> attributes;
	
	public BasicSubjAltNames(XmlBuildParams params, PolicyOID policy, List<Attribute> attributes) {
		this.params = params;
		this.xmlInfo = params.getXmlInfo();
		this.policy = policy;
		this.oidMap = params.getOidMap();
		this.identificationType = params.getIdentificationType();
		this.attributes=attributes;
		
	}

	public List<SubjectAlternateName> build() {
		List<SubjectAlternateName> list=new ArrayList<>();
		if (params.isSanIncludeRFC822Name()) {
			String mail = xmlInfo.getAttributeValue(BCStyle.EmailAddress.getId());
			if (mail != null && !mail.isBlank()) {
				list.add(new SubjectAlternateName(mail.trim()));
			} 
		}
		return list;
	}

	protected void addSubjectAlternateNameOid(List<SubjectAlternateName> list, String oid, String value) {
		SubjectAlternateName subjectAlternateName = null;
		if(value!=null && !value.isEmpty()) {
			subjectAlternateName=new SubjectAlternateName(oid,value.trim());
			list.add(subjectAlternateName);
		}
	}
	

	protected String attribute(String oid) {
		return attributes.stream().filter(a->a.getAttributeType().equals(oid)).map(Attribute::getAttributeValue).findFirst().orElse(null);
	}
}
