package com.anf.ws.ar.xml.service.params;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import com.anf.cryptotoken.oid.IANACode;
import com.anf.ra.xml.ApplicationForm;
import com.anf.ws.ar.enums.CertificateModality;
import com.anf.ws.ar.enums.IdentificationType;
import com.anf.ws.ar.xml.attributes.XmlAttributesReader;
import com.anf.ws.ar.xml.model.DocumentFile;
import com.anf.ws.ar.xml.types.CertificateType;
import com.fasterxml.jackson.annotation.JsonIgnore;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Builder.Default;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class XmlBuildParams {
	
	@Default
	private IdentificationType identificationType=IdentificationType.FISICA;

	@Default
	@JsonIgnore
	private Map<String, String> oidMap=new TreeMap<>();

	@Default
	private String ianaCode=IANACode.ANF_ES.getIanaCode();

	private String companyId;
	
	private String arRDP;
		
	private CertificateType certType;
	private CertificateModality modality;
	
	private String localizador;
	private String arLocalizator;
	
	private Integer validityDays;
	private boolean shortVigency;
	
	private List<DocumentFile> docs;
	
	private String ouProfile;	

	private String orgDepartment;
	
	private String codeDIR3;

	private String identNumber;
	
	private PSD2Params psd2;
	
	private EprelParams eprelParams;
	
	@JsonIgnore
	private XmlAttributesReader xmlInfo;

	private boolean test;

	@Default
	private int keySize=2048;
	
	private String signAlg;

	@Default
	private boolean sanIncludeCNAndSerial=true;
	
	private List<String> extendedKeyUsages;
	
	private String qcpOid;

	@Default
	private boolean sanIncludeRFC822Name=true;
	
	private Boolean qscd;

	@JsonIgnore
	private ApplicationForm xmlForm;
	

	/**
	 * Relaciona el arco del OID sin el prefijo hasta IANA, con el valor que debe tener ese OID en el Subj Alt Names 
	 * @param oid es el arco del OID sin el prefijo hasta IANA, o esea si el OID final es 1.3.6.1.4.1.18332.10.1, este oid seria 10.1 solamente
	 * @param value el valor del OID en el Subj Alt Names
	 */
	public void addOidValue(String oid,String value) {
		oidMap.put(oid, value);
	}
	
}
