/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.anf.ws.ar.xml.service;

import java.io.File;
import java.util.List;

import com.anf.cryptotoken.oid.PolicyOID;
import com.anf.ra.xml.ApplicationForm.Applicant.Attributes.Attribute;
import com.anf.ws.ar.enums.CertificateModality;
import com.anf.ws.ar.enums.ProfileType;
import com.anf.ws.ar.xml.attributes.AttributesProfile;
import com.anf.ws.ar.xml.attributes.AttributesProfileFactory;
import com.anf.ws.ar.xml.attributes.XmlAttributesReader;
import com.anf.ws.ar.xml.builder.XMLBuilder;
import com.anf.ws.ar.xml.ekusages.ExtKeyUsagesProfile;
import com.anf.ws.ar.xml.ekusages.ExtKeyUsagesProfileFactory;
import com.anf.ws.ar.xml.exception.XMLRequestException;
import com.anf.ws.ar.xml.extensions.ExtensionsProfileFactory;
import com.anf.ws.ar.xml.extensions.ExtensionsProfileParams;
import com.anf.ws.ar.xml.io.XmlWriter;
import com.anf.ws.ar.xml.key.KeyProfileFactory;
import com.anf.ws.ar.xml.kusages.KeyUsagesProfile;
import com.anf.ws.ar.xml.kusages.KeyUsagesProfileFactory;
import com.anf.ws.ar.xml.model.ExtendedKeyUsage;
import com.anf.ws.ar.xml.model.Extension;
import com.anf.ws.ar.xml.model.Key;
import com.anf.ws.ar.xml.model.KeyUsage;
import com.anf.ws.ar.xml.model.PolicyInfo;
import com.anf.ws.ar.xml.model.QcStatements;
import com.anf.ws.ar.xml.model.SubjectAlternateName;
import com.anf.ws.ar.xml.model.SubjectDirectory;
import com.anf.ws.ar.xml.policy.PoliciesProfile;
import com.anf.ws.ar.xml.policy.PoliciesProfileFactory;
import com.anf.ws.ar.xml.qcstatements.QcStatementsProfileFactory;
import com.anf.ws.ar.xml.service.params.XmlBuildParams;
import com.anf.ws.ar.xml.subjaltnames.SubjAltNames;
import com.anf.ws.ar.xml.subjaltnames.SubjAltNamesFactory;
import com.anf.ws.ar.xml.types.CertificateType;

/**
 *
 * @author Aramis
 */
public class XmlBuildService {

	static final String pathTemp = "/opt/gestion/wsar/temp/";

	public File buildXml(XmlBuildParams params) {
		
		try {

			XMLBuilder xmlBuilder=new XMLBuilder();
			
			CertificateType certType=params.getCertType();
			CertificateModality modality=params.getModality();
			ProfileType profileType = getProfileTypeFromModality(modality);
			XmlAttributesReader xmlInfo=params.getXmlInfo();

			AttributesProfile attributesProfile = AttributesProfileFactory.getAttributes(params, certType);
			List<Attribute> attributes = attributesProfile.build();
			
			xmlBuilder.buildAttributes(attributes);

			String country=attributesProfile.getCountry();

			if(country==null)
				country="ES";//ES para que cojan todos el oid con el IANA 18332

			String ianaCode = params.getIanaCode();
			PolicyOID policy=PolicyOID.fromIANACode(ianaCode);

			
			PoliciesProfile policiesProfile = PoliciesProfileFactory.getPoliciesProfile(certType,params.getQcpOid());
			List<PolicyInfo> politicas=policiesProfile.getPolicies(policy, profileType);				
			xmlBuilder.buildXmlPolicies(politicas);

			KeyUsagesProfile keyUsagesProfile = KeyUsagesProfileFactory.getKeyUsages(certType);
			List<KeyUsage> keyUsages=keyUsagesProfile.getKeyUsages(profileType);
			xmlBuilder.buildKeyUsages(keyUsages);

			ExtKeyUsagesProfile extKeyUsagesProfile = ExtKeyUsagesProfileFactory.getExtKeyUsages(certType);
			List<ExtendedKeyUsage> extendedKeyUsages = extKeyUsagesProfile.getExtKeyUsages(profileType, params.getExtendedKeyUsages());
			xmlBuilder.buildExtKeyUsages(extendedKeyUsages);

			Key key = KeyProfileFactory.getKeyProfile().build(params.getSignAlg(), params.getKeySize());
			xmlBuilder.buildKey(key);

			//obligatorio excepto para EC donde no deben ponerse
			QcStatements qc = QcStatementsProfileFactory.getQcStatementsProfile(country,certType).build(modality,params.getQscd());
			if(qc!=null && certType==CertificateType.QSEALC_PSD2)
				qc.setPsd2(params.getPsd2());
			xmlBuilder.buildQcStatements(qc);

			String localizador=params.getLocalizador();
			ExtensionsProfileParams extParams=
					new ExtensionsProfileParams(localizador, xmlInfo, params.getCompanyId(),  
							params.getArRDP(), params.getArLocalizator(), policy, params.getValidityDays(), params.isShortVigency());
			extParams.setTest(params.isTest());
			List<Extension> extList = ExtensionsProfileFactory.getExtensionsProfile(certType).build(extParams);

			xmlBuilder.buildExtensions(extList);		

			//opcional            
			List<SubjectDirectory> subjecDirectories = null;
			xmlBuilder.buildSubjDirAttributes(subjecDirectories);

			SubjAltNames subjAltNames = SubjAltNamesFactory.getSubjAltNames(certType,params, policy, attributes);
			List<SubjectAlternateName> list = subjAltNames.build();
			xmlBuilder.buildSubjAltNames(list);

			File xmlFile = tmpXmlFile(localizador);
			XmlWriter.writeXml(xmlBuilder.appForm(), xmlFile);

			return xmlFile;

		} catch (Exception ex) {
			throw new XMLRequestException(ex);
		}finally {
			System.gc();
		}
	}

	private ProfileType getProfileTypeFromModality(CertificateModality modality) {
		switch (modality) {
		case CENTRALIZED: return ProfileType.Centralized;
		case QSCD: return ProfileType.QSCD;
		case SOFTWARE: return ProfileType.Software;
		case EXPORTABLE: return ProfileType.KeyDist;
		default:
			return ProfileType.KeyDist;
		}
	}

	private File tmpXmlFile(String localizador) {
		File tmpLocDir = new File(pathTemp,localizador);
		if (!tmpLocDir.exists()) {
			tmpLocDir.mkdirs();
		}
		File xmlFile = new File(tmpLocDir,localizador + ".xml");
		return xmlFile;
	}
	
}
