package com.anf.ws.ar.xml.policy.impl;

import java.util.ArrayList;
import java.util.List;

import com.anf.cryptotoken.oid.IANACode;
import com.anf.cryptotoken.oid.PolicyOID;
import com.anf.ws.ar.enums.ProfileType;
import com.anf.ws.ar.enums.TypeCert;
import com.anf.ws.ar.xml.model.PolicyInfo;
import com.anf.ws.ar.xml.policy.CertTypePolicyGenerator;
import com.anf.ws.ar.xml.policy.PoliciesProfile;
import com.anf.ws.ar.xml.policy.PolicyInfoBuilder;
import com.anf.ws.ar.xml.types.CertificateType;
import com.anf.ws.ar.xml.types.TypeCertConverter;

public class StandardPoliciesProfile extends TypeCertConverter implements PoliciesProfile{
	
	private String specificOid;
	
	private String qcpOid;
	
	public StandardPoliciesProfile(CertificateType type, String specificOid, String qcpOid) {
		super(type);
		this.specificOid = specificOid;
		this.qcpOid = qcpOid;
	}

	public List<PolicyInfo> getPolicies(PolicyOID policyOid,ProfileType policyType) {
		List<PolicyInfo> policies=new ArrayList<>();

		TypeCert typeCert = convertType(policyType);
		
		String mainPolicyOid = mainPolicyOid(policyOid, policyType);
		PolicyInfo mainPolicy = mainPolicy(typeCert, mainPolicyOid, policyType);
		if(policyOid.getIanaCode().equals(IANACode.ANF_EC.getIanaCode()))
			mainPolicy.setUrl("https://anf.es/ec/repositorio-legal/");		
		
		policies.add(mainPolicy);
		
		policies.addAll(additionalOids().stream().map(oid->PolicyInfoBuilder.build(typeCert,oid,true)).toList());
		
		return policies;
	}

	protected PolicyInfo mainPolicy(TypeCert typeCert, String mainPolicyOid, ProfileType policyType) {
		return PolicyInfoBuilder.build(typeCert, mainPolicyOid);
	}

	protected String mainPolicyOid(PolicyOID policyOid, ProfileType policyType) {
		return CertTypePolicyGenerator.getPolicy(policyOid, type, policyType);
	}
	
	protected List<String> additionalOids(){
		List<String> oids=new ArrayList<>();
		if(specificOid!=null && !specificOid.isBlank())
			oids.add(specificOid);

		if(qcpOid!=null && !qcpOid.isBlank())
			oids.add(qcpOid);
		return oids;
	}
}
