package com.anf.ws.ar.xml.policy;

import com.anf.cryptotoken.oid.ProfilePolicy;
import com.anf.ws.ar.xml.policy.impl.EcuadorPoliciesProfile;
import com.anf.ws.ar.xml.policy.impl.StandardPoliciesProfile;
import com.anf.ws.ar.xml.types.CertificateType;

public class PoliciesProfileFactory {

	public static PoliciesProfile getPoliciesProfile(CertificateType type, String qcpOid) {
		switch (type) {
		case PERSONA_NATURAL_EC, MIEMBRO_EMPRESA_EC, REP_LEGAL_EC, SELLO_ELECTRONICO_EC: 
			return new EcuadorPoliciesProfile(type, specificOid(type),qcpOid);
		default:
			return new StandardPoliciesProfile(type, specificOid(type),qcpOid);
		}


	}

	private static String specificOid(CertificateType type){
		switch (type) {
		case REP_LEGAL_PJ, REP_LEGAL_ADMIN_UNICOS:return ProfilePolicy.RL_PJ_Firma_SegSocial.getOid();
		case REP_LEGAL_SIN_PJ:return ProfilePolicy.RL_SPJ_Firma_SegSocial.getOid();
		case EMPLEADO_PUBLICO_ALTO: return ProfilePolicy.EP_Alto_Firma_SegSocial.getOid();
		case EMPLEADO_PUBLICO_MEDIO: return ProfilePolicy.EP_Medio_Firma_SegSocial.getOid();
		case QSEALC_AP_MEDIO: return "2.16.724.1.3.5.6.2";
		case QSEALC_AP_ALTO: return "2.16.724.1.3.5.6.1";
		default:
			return null;
		}
	}
}
