package com.anf.ws.ar.xml.model;

import java.util.Objects;

import com.anf.ws.ar.enums.TypeCert;

public class PolicyInfo implements java.io.Serializable {

    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
    private String typeCert;
    private String oid;
    private String url;
    private String userNotice;

    public PolicyInfo() {
    }
    
    public PolicyInfo(TypeCert typeCert, String oid) {
		super();
		this.typeCert = typeCert.name();
		this.oid = oid;
	}

	public PolicyInfo(String typeCert, String oid, String url, String userNotice) {
        this.typeCert = typeCert;
        this.oid = oid;
        this.url = url;
        this.userNotice = userNotice;
    }

    public String getTypeCert() {
        return this.typeCert;
    }

    public void setTypeCert(String typeCert) {
        this.typeCert = typeCert;
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUserNotice() {
        return this.userNotice;
    }

    public void setUserNotice(String userNotice) {
        this.userNotice = userNotice;
    }


    @Override
    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode(this.typeCert);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final PolicyInfo other = (PolicyInfo) obj;
        if (!Objects.equals(this.typeCert, other.typeCert)) {
            return false;
        }
        return true;
    }

}
