package com.anf.ws.ar.xml.localizator;

import com.anf.ws.ar.enums.CertificateModality;
import com.anf.ws.ar.xml.localizator.impl.StandardLocalizatorProfile;
import com.anf.ws.ar.xml.localizator.impl.SuffixLocalizatorProfile;

public interface LocalizatorProfileFactory {

	static LocalizatorProfile getLocalizatorProfile(String arLocalizator, CertificateModality modality, String suffix) {

		if (suffix != null && !suffix.isBlank())
			return new SuffixLocalizatorProfile(suffix);

		switch (modality) {
		case PFX_IESA_TEST:
			return new SuffixLocalizatorProfile("1000");
		case PFX_IESA_PRO:
			return new SuffixLocalizatorProfile("10");
		case PFX_ECUADOR_TEST:
			return new SuffixLocalizatorProfile("2000");
		case PFX_ECUADOR_PRO:
			return new SuffixLocalizatorProfile("20");
		case EXPORTABLE:
		case CENTRALIZED:
		default:
			return new StandardLocalizatorProfile(arLocalizator);
		}
	}
}
