package com.anf.ws.ar.xml.extensions.impl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

import org.bouncycastle.util.encoders.Hex;

import com.anf.ws.ar.xml.attributes.XmlAttributesReader;
import com.anf.ws.ar.xml.extensions.ExtensionsProfile;
import com.anf.ws.ar.xml.extensions.ExtensionsProfileParams;
import com.anf.ws.ar.xml.model.Extension;
import com.anf.ws.ar.xml.types.CertificateType;

public class ExtensionsProfileImpl implements ExtensionsProfile{

	private CertificateType type;

	public ExtensionsProfileImpl(CertificateType type) {
		this.type=type;
	}

	public List<Extension> build(ExtensionsProfileParams params) throws NoSuchAlgorithmException {
		List<Extension> extensiones = new ArrayList<>();

		String root = params.getPolicy().policyRoot().getId();

		String localizador = params.getLocalizador();
		addExtension(buildExtension("1.3.6.1.4.1.18332.19", localizador, false), extensiones);

		if(!type.isSeal()) {
			if(params.getArLocalizator()!=null) {
				addExtension(buildExtension(root+".19.1", params.getArLocalizator(), false), extensiones);
			}
			String companyId = params.getCompanyId();
			if(companyId==null || companyId.isEmpty())
				companyId="0";
			if(companyId!=null) {
				addExtension(buildExtension("1.3.6.1.4.1.18332.19.2", companyId, false), extensiones);
			}

			if(params.isShortVigency() && params.getDiasValidez()<730) {
				addExtension(buildExtension(root+".46", "1", false), extensiones);
			}

			addExtension(buildExtension(root+".46.1", String.valueOf(params.getDiasValidez()), false), extensiones);

			addExtension(buildExtension(root+".47.1", hash(localizador), false), extensiones);//UUID del token

			if(params.getArRDP()!=null) {
				addExtension(buildExtension(root+".42.1", params.getArRDP(), false), extensiones);
			}

			addOperatorExtensions(extensiones, root);

			addEcuadorExtensions(params, extensiones, root);

			if(params.isTest())  
				addExtension(buildExtension("1.3.6.1.4.1.18332.3.1.1.0", "TEST", false), extensiones);     

		}
		return extensiones;
	}

	private void addOperatorExtensions(List<Extension> extensiones, String root) {
		String oid=null;
		String value=null;
		boolean add=false;

		switch (type) {
		case OPERADOR_AR:
			add=true;
			oid=root+".42.2";
			value="Autoridad de Registro Reconocida Nivel 1";
			break;

		case OPERADOR_AR_2:
			add=true;
			oid=root+".42.4";
			value="Autoridad de Registro Reconocida Nivel 2";
			break;
		case RDE:
			add=true;
			oid=root+".42.3";
			value="RESPONSABLE DICTAMEN DE EMISIÓN";
			break;

		case OPERADOR_PKI:
			add=true;
			oid=root+".42.9";
			value=" Operador Autorizado PKI";
			break;

		case OPERADOR_PKI_ADMIN:
			add=true;
			oid=root+".42.10";
			value=" Operador Autorizado PKI ADMIN";
			break;

		default:
			break;
		}
		if(add)
			addExtension(buildExtension(oid, value, false), extensiones);
	}

	private void addEcuadorExtensions(ExtensionsProfileParams params, List<Extension> extensiones, String root) {
		XmlAttributesReader xmlInfo = params.getInformacionXml();
		String pais = xmlInfo.getAttributeValue("2.5.4.6");
		if (pais!=null && pais.equalsIgnoreCase("EC") && !type.match(CertificateType.PERSONA_NATURAL_EC,CertificateType.MIEMBRO_EMPRESA_EC, CertificateType.REP_LEGAL_EC, CertificateType.SELLO_ELECTRONICO_EC)) {
			String dni = xmlInfo.getAttributeValue("2.5.4.5");
			String nombre = xmlInfo.getAttributeValue("2.5.4.42");
			String apellidos = xmlInfo.getAttributeValue("2.5.4.4");
			String ruc = xmlInfo.getAttributeValue("2.5.4.97");
			String razonSocial = xmlInfo.getAttributeValue("2.5.4.10");
			String ciudad = xmlInfo.getAttributeValue("2.5.4.7");
			String cargo = xmlInfo.getAttributeValue("2.5.4.12");

			addExtension(buildExtension(root+".3.1", dni, false), extensiones);
			addExtension(buildExtension(root+".3.2", nombre, false), extensiones);
			addExtension(buildExtension(root+".3.3", apellidos, false), extensiones);
			addExtension(buildExtension(root+".3.5", cargo, false), extensiones);
			addExtension(buildExtension(root+".3.9", ciudad, false), extensiones);
			addExtension(buildExtension(root+".3.10", razonSocial, false), extensiones);
			addExtension(buildExtension(root+".3.11", ruc, false), extensiones);       
			addExtension(buildExtension(root+".3.12", pais, false), extensiones);          

		}
	}
	

	Extension buildExtension(String oid,String value,boolean critical){
		Extension extension = null;
		if (value!=null && !value.isEmpty()) {
			extension = new Extension();
			extension.setExtensionOid(oid);
			extension.setExtensionCritical(critical);
			extension.setExtensionValue(value);
		}
		return extension;
	}
	
	void addExtension(Extension ext,List<Extension> extensiones){
		if(ext!=null)
			extensiones.add(ext);
	}
	
	private String hash(String value) throws NoSuchAlgorithmException {
		byte[] hash = MessageDigest.getInstance("SHA-256").digest(value.getBytes());
		return new String(Hex.encode(hash));
	}


}
