package com.anf.ws.ar.xml.builder;

import java.util.List;

import com.anf.ra.xml.ApplicationForm;
import com.anf.ra.xml.ApplicationForm.Applicant;
import com.anf.ra.xml.ObjectFactory;
import com.anf.ws.ar.xml.model.KeyUsage;

public class XmlKeyUsagesBuilder {

	private ObjectFactory xmlFactory;
		
	private Applicant applicant;
	
	public XmlKeyUsagesBuilder(ObjectFactory xmlFactory, Applicant applicant) {
		this.xmlFactory=xmlFactory;
		this.applicant=applicant;
	}

	public void setkeyUsages(List<KeyUsage> keyUsages) {
		/**
		 * Se inserta la informacion correspondiente al nodo keyusagesnode.
		 */
		if (keyUsages != null && !keyUsages.isEmpty()) {
			ApplicationForm.Applicant.Keyusagesnode keyusagesnode = xmlFactory.createApplicationFormApplicantKeyusagesnode();
			for (KeyUsage ku : keyUsages) {
				ApplicationForm.Applicant.Keyusagesnode.Keyusages keyusages = xmlFactory.createApplicationFormApplicantKeyusagesnodeKeyusages();
				keyusages.setKeyusagestypecert(ku.getKeyUsagesTypeCert());
				keyusages.getKeyusage().addAll(ku.getKeyUsages());
				keyusagesnode.getKeyusages().add(keyusages);
			}
			applicant.setKeyusagesnode(keyusagesnode);
		}
	}
}
