package com.anf.ws.ar.xml.builder;

import java.util.List;

import com.anf.ra.xml.ApplicationForm;
import com.anf.ra.xml.ApplicationForm.Applicant;
import com.anf.ra.xml.ObjectFactory;
import com.anf.ws.ar.xml.model.Extension;

public class XmlExtensionsBuilder {

	private ObjectFactory xmlFactory;
	
	private Applicant applicant;
	
	public XmlExtensionsBuilder(ObjectFactory xmlFactory, Applicant applicant) {
		this.xmlFactory=xmlFactory;
		this.applicant=applicant;
	}

	public void setExtensions(List<Extension> extList) {
		/**
		 * Se inserta la informacion correspondiente al nodo Extensions.
		 */
		if (extList != null && !extList.isEmpty()) {
			ApplicationForm.Applicant.Extensions extensions = xmlFactory.createApplicationFormApplicantExtensions();
			for (Extension e : extList) {
				ApplicationForm.Applicant.Extensions.Extension extension = xmlFactory.createApplicationFormApplicantExtensionsExtension();
				String critical = "";
				if (e.getExtensionCritical()) {
					critical = "true";
				} else {
					critical = "false";
				}
				extension.setExtensionOID(e.getExtensionOid());
				extension.setExtensionValue(e.getExtensionValue());
				extension.setCritical(critical);
				extensions.getExtension().add(extension);
			}

			applicant.setExtensions(extensions);
		}

	}
}
