package com.anf.ws.ar.xml.builder;

import java.util.List;

import com.anf.ra.xml.ApplicationForm;
import com.anf.ra.xml.ApplicationForm.Applicant;
import com.anf.ra.xml.ObjectFactory;
import com.anf.ws.ar.xml.model.ExtendedKeyUsage;

public class XmlExtKeyUsagesBuilder {

	private ObjectFactory xmlFactory;
	
	private Applicant applicant;
	
	public XmlExtKeyUsagesBuilder(ObjectFactory xmlFactory, Applicant applicant) {
		this.xmlFactory=xmlFactory;
		this.applicant=applicant;
	}

	public void setExtKeyUsages(List<ExtendedKeyUsage> extendedKeyUsages) {

		/**
		 * Se inserta la informacion correspondiente al nodo
		 * ExtendedKeyUsagesnode.
		 */
		ApplicationForm.Applicant.ExtendedKeyUsagesnode extendedkeyusagesnode = xmlFactory.createApplicationFormApplicantExtendedKeyUsagesnode();
		if (extendedKeyUsages != null && !extendedKeyUsages.isEmpty()) {
			for (ExtendedKeyUsage eku : extendedKeyUsages) {
				ApplicationForm.Applicant.ExtendedKeyUsagesnode.ExtendedKeyUsages extendedkeyusages = xmlFactory.createApplicationFormApplicantExtendedKeyUsagesnodeExtendedKeyUsages();
				extendedkeyusages.setExtendedKeyUsageTypeCert(eku.getExtendedKeyUsageTypeCert());
				extendedkeyusages.getExtendedKeyUsage().addAll(eku.getExtendedKeyUsages());

				extendedkeyusagesnode.getExtendedKeyUsages().add(extendedkeyusages);
			}
			applicant.setExtendedKeyUsagesnode(extendedkeyusagesnode);
		}
	}
}
