package com.anf.ws.ar.xml.builder;

import java.util.List;

import com.anf.ra.xml.ApplicationForm;
import com.anf.ra.xml.ApplicationForm.Applicant.Attributes.Attribute;
import com.anf.ra.xml.ObjectFactory;
import com.anf.ws.ar.xml.model.ExtendedKeyUsage;
import com.anf.ws.ar.xml.model.Extension;
import com.anf.ws.ar.xml.model.Key;
import com.anf.ws.ar.xml.model.KeyUsage;
import com.anf.ws.ar.xml.model.PolicyInfo;
import com.anf.ws.ar.xml.model.QcStatements;
import com.anf.ws.ar.xml.model.SubjectDirectory;

public class XMLBuilder {

	private ApplicationForm appForm;
	
	private XmlPoliciesBuilder policiesBuilder;
	
	private XmlAttributesBuilder attributesBuilder;
	
	private XmlKeyUsagesBuilder keyUsagesBuilder;
	
	private XmlExtKeyUsagesBuilder extKeyUsagesBuilder;
	
	private XmlKeyBuilder keyBuilder;
	
	private XmlQcStatementsBuilder qcStatementsBuilder;
	
	private XmlExtensionsBuilder extensionsBuilder;
	
	private XmlSubjDirAttributesBuilder subjDirAttributesBuilder;
	
	private XmlSubjAltNamesBuilder subjAltNamesBuilder;

	public XMLBuilder() {
		super();
		ObjectFactory xmlFactory = new ObjectFactory();
		
		appForm = xmlFactory.createApplicationForm();
		ApplicationForm.Applicant applicant = xmlFactory.createApplicationFormApplicant();
		appForm.setApplicant(applicant);
		
		policiesBuilder=new XmlPoliciesBuilder(xmlFactory,appForm,applicant);
		attributesBuilder=new XmlAttributesBuilder(xmlFactory,applicant);
		keyUsagesBuilder=new XmlKeyUsagesBuilder(xmlFactory,applicant);
		extKeyUsagesBuilder=new XmlExtKeyUsagesBuilder(xmlFactory, applicant);
		keyBuilder=new XmlKeyBuilder(xmlFactory,applicant);
		qcStatementsBuilder=new XmlQcStatementsBuilder(xmlFactory, applicant);
		extensionsBuilder=new XmlExtensionsBuilder(xmlFactory, applicant);
		subjDirAttributesBuilder=new XmlSubjDirAttributesBuilder(xmlFactory, applicant);
		subjAltNamesBuilder=new XmlSubjAltNamesBuilder(xmlFactory, applicant);
		
	}
		
	public void buildAttributes(List<Attribute> attributes) {
		attributesBuilder.setAttributes(attributes);
	}

	public void buildXmlPolicies(List<PolicyInfo> politicas) {
		policiesBuilder.setPolicies(politicas);
	}
	
	public void buildKeyUsages(List<KeyUsage> keyUsages) {
		keyUsagesBuilder.setkeyUsages(keyUsages);
	}
	
	public void buildExtKeyUsages(List<ExtendedKeyUsage> extendedKeyUsages) {
		extKeyUsagesBuilder.setExtKeyUsages(extendedKeyUsages);
	}

	public void buildKey(Key key) {
		keyBuilder.setKey(key);
	}

	public void buildQcStatements(QcStatements qc) {
		qcStatementsBuilder.setQcStatements(qc);
	}

	public void buildExtensions(List<Extension> extList) {
		extensionsBuilder.setExtensions(extList);
	}

	public void buildSubjDirAttributes(List<SubjectDirectory> subjecDirectories) {
		subjDirAttributesBuilder.setSubjDirAttributes(subjecDirectories);
	}

	public void buildSubjAltNames(List<com.anf.ws.ar.xml.model.SubjectAlternateName> list) {
		subjAltNamesBuilder.setSubjAltNames(list);
	}

	public ApplicationForm appForm() {
		return appForm;
	}	
	
}
