package com.anf.ws.ar.xml.attributes.impl;

import java.util.List;

import org.bouncycastle.asn1.x500.style.BCStyle;

import com.anf.ra.xml.ApplicationForm;
import com.anf.ra.xml.ApplicationForm.Applicant.Attributes.Attribute;
import com.anf.ws.ar.services.OrgIdFormatter;
import com.anf.ws.ar.xml.service.params.EprelParams;
import com.anf.ws.ar.xml.service.params.XmlBuildParams;
import com.anf.ws.ar.xml.types.CertificateType;

public class QSealAttributesProfile extends SignAttributesProfile {

	private final String ouProfileBase="Certificado Cualificado de Sello Electronico";

	public QSealAttributesProfile(XmlBuildParams params, CertificateType certType) {
		super(params, certType);
	}

	@Override
	protected void updateSerialNumber(List<Attribute> attributes) {
		ApplicationForm.Applicant.Attributes.Attribute orgId=null;
		ApplicationForm.Applicant.Attributes.Attribute serial=null;
		String cif=null;
		boolean eprel=false;
		for (ApplicationForm.Applicant.Attributes.Attribute a : attributes) {
			if (orgId==null && a.getAttributeType().equals(BCStyle.SERIALNUMBER.getId())) {
				cif=a.getAttributeValue().replace("IDC"+country+"-", "");
				a.setAttributeValue(cif);
				serial=a;
			}else if (a.getAttributeType().equals(BCStyle.ORGANIZATION_IDENTIFIER.getId())) {
				orgId=a;
				cif=orgId.getAttributeValue();
				EprelParams eprelParams = params.getEprelParams();
				eprel=eprelParams!=null;
				if(eprel)
					a.setAttributeValue(OrgIdFormatter.fix(eprelParams.getBusinessRegisterId()+"."+eprelParams.getRegistrationNumber(),eprelParams.getTypeIdentifier(),country));
				else if(!OrgIdFormatter.isFormatted(cif))
					cif=OrgIdFormatter.fix(cif, "VAT", country);
			}
		}

		String orgNif=cif;

		if(certType==CertificateType.QSEALC_PSD2) {
			if(params.getPsd2()!=null) {
				orgNif=params.getPsd2().buildOrgField();
			}
		}else if(!eprel && cif!=null && !OrgIdFormatter.isFormatted(cif))
			orgNif=cif=OrgIdFormatter.fix(cif, "VAT", country);

		if (!eprel && orgNif!=null) {
			if (orgId == null) {
				attributes.add(new Attribute(BCStyle.ORGANIZATION_IDENTIFIER.getId(), orgNif));
			} else
				orgId.setAttributeValue(orgNif);			
		}
		if(cif!=null && (!OrgIdFormatter.isFormatted(cif) || cif.startsWith("VAT"))){
			cif=OrgIdFormatter.clean(cif);
			if (serial == null) {
				attributes.add(new Attribute(BCStyle.SERIALNUMBER.getId(), cif));
			} else
				serial.setAttributeValue(cif);
		}
	}

	@Override
	protected String organizationalUnit() {
		switch (certType) {
		case QSEALC: return ouProfileBase;
		case QSEALC_PSD2: return ouProfileBase+" PSD2";
		case QSEALC_AP_MEDIO: return ouProfileBase+" AA.PP. Nivel Medio";
		case QSEALC_AP_ALTO: return ouProfileBase+" AA.PP. Nivel Alto";		
		default:
			return super.organizationalUnit();
		}
	}
}
