/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.pades.validation.PdfObjectKey;
import eu.europa.esig.dss.pdf.PdfArray;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSSDictionaryExtractionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DSSDictionaryExtractionUtils.class);

    private DSSDictionaryExtractionUtils() {
    }

    public static Map<PdfObjectKey, CertificateToken> getCertsFromArray(PdfDict dict, String dictionaryName, String arrayName) {
        LinkedHashMap<PdfObjectKey, CertificateToken> certMap = new LinkedHashMap<PdfObjectKey, CertificateToken>();
        PdfArray certsArray = dict.getAsArray(arrayName);
        if (certsArray != null) {
            LOG.debug("There are {} certificates in the '{}' dictionary", (Object)certsArray.size(), (Object)dictionaryName);
            for (int ii = 0; ii < certsArray.size(); ++ii) {
                try {
                    PdfObjectKey objectKey = certsArray.getObjectKey(ii);
                    if (certMap.containsKey(objectKey)) continue;
                    certMap.put(objectKey, DSSUtils.loadCertificate((byte[])certsArray.getStreamBytes(ii)));
                    continue;
                }
                catch (Exception e) {
                    LOG.debug("Unable to read Cert '{}' from the '{}' dictionary : {}", new Object[]{ii, dictionaryName, e.getMessage(), e});
                }
            }
        } else {
            LOG.debug("No Certs found in the '{}' dictionary", (Object)dictionaryName);
        }
        return certMap;
    }

    public static Map<PdfObjectKey, CRLBinary> getCRLsFromArray(PdfDict dict, String dictionaryName, String arrayName) {
        LinkedHashMap<PdfObjectKey, CRLBinary> crlMap = new LinkedHashMap<PdfObjectKey, CRLBinary>();
        PdfArray crlArray = dict.getAsArray(arrayName);
        if (crlArray != null) {
            LOG.debug("There are {} CRLs in the '{}' dictionary", (Object)crlArray.size(), (Object)dictionaryName);
            for (int ii = 0; ii < crlArray.size(); ++ii) {
                try {
                    PdfObjectKey objectKey = crlArray.getObjectKey(ii);
                    if (crlMap.containsKey(objectKey)) continue;
                    crlMap.put(objectKey, CRLUtils.buildCRLBinary((byte[])crlArray.getStreamBytes(ii)));
                    continue;
                }
                catch (Exception e) {
                    LOG.debug("Unable to read CRL '{}' from the '{}' dictionary : {}", new Object[]{ii, dictionaryName, e.getMessage(), e});
                }
            }
        } else {
            LOG.debug("No CRLs found in the '{}' dictionary", (Object)dictionaryName);
        }
        return crlMap;
    }

    public static Map<PdfObjectKey, OCSPResponseBinary> getOCSPsFromArray(PdfDict dict, String dictionaryName, String arrayName) {
        LinkedHashMap<PdfObjectKey, OCSPResponseBinary> ocspMap = new LinkedHashMap<PdfObjectKey, OCSPResponseBinary>();
        PdfArray ocspArray = dict.getAsArray(arrayName);
        if (ocspArray != null) {
            LOG.debug("There are {} OCSPs in the '{}' dictionary", (Object)ocspArray.size(), (Object)dictionaryName);
            for (int ii = 0; ii < ocspArray.size(); ++ii) {
                try {
                    PdfObjectKey objectKey = ocspArray.getObjectKey(ii);
                    if (ocspMap.containsKey(objectKey)) continue;
                    OCSPResp ocspResp = new OCSPResp(ocspArray.getStreamBytes(ii));
                    BasicOCSPResp basicOCSPResp = (BasicOCSPResp)ocspResp.getResponseObject();
                    ocspMap.put(objectKey, OCSPResponseBinary.build((BasicOCSPResp)basicOCSPResp));
                    continue;
                }
                catch (Exception e) {
                    LOG.debug("Unable to read OCSP '{}' from the '{}' dictionary : {}", new Object[]{ii, dictionaryName, e.getMessage(), e});
                }
            }
        } else {
            LOG.debug("No OCSPs found in the '{}' dictionary", (Object)dictionaryName);
        }
        return ocspMap;
    }

    public static Date getDictionaryCreationTime(PdfDict dict) {
        return dict.getDateValue("TU");
    }

    public static byte[] getTimestampBinaries(PdfDict dict) {
        PdfDict tsDict = dict.getAsDict("TS");
        if (tsDict != null) {
            try {
                return tsDict.getStreamBytes();
            }
            catch (IOException e) {
                LOG.warn("Unable to extract 'TS' stream : {}", (Object)e.getMessage());
            }
        }
        return null;
    }
}

