/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.pades.PAdESCommonParameters;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.SignatureFieldParameters;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pades.exception.InvalidPasswordException;
import eu.europa.esig.dss.pades.validation.ByteRange;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.PdfByteRangeDocument;
import eu.europa.esig.dss.pades.validation.PdfRevision;
import eu.europa.esig.dss.pades.validation.PdfSignatureDictionary;
import eu.europa.esig.dss.pades.validation.PdfSignatureField;
import eu.europa.esig.dss.pades.validation.PdfValidationDataContainer;
import eu.europa.esig.dss.pades.validation.dss.PdfCompositeDssDictionary;
import eu.europa.esig.dss.pades.validation.timestamp.PdfTimestampToken;
import eu.europa.esig.dss.pdf.AnnotationBox;
import eu.europa.esig.dss.pdf.PDFServiceMode;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.pdf.PdfArray;
import eu.europa.esig.dss.pdf.PdfCMSRevision;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.PdfDocDssRevision;
import eu.europa.esig.dss.pdf.PdfDocTimestampRevision;
import eu.europa.esig.dss.pdf.PdfDocumentReader;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfMemoryUsageSetting;
import eu.europa.esig.dss.pdf.PdfPermissionsChecker;
import eu.europa.esig.dss.pdf.PdfSignatureCache;
import eu.europa.esig.dss.pdf.PdfSignatureDictionaryComparator;
import eu.europa.esig.dss.pdf.PdfSignatureFieldPositionChecker;
import eu.europa.esig.dss.pdf.PdfSignatureRevision;
import eu.europa.esig.dss.pdf.modifications.DefaultPdfDifferencesFinder;
import eu.europa.esig.dss.pdf.modifications.DefaultPdfObjectModificationsFinder;
import eu.europa.esig.dss.pdf.modifications.PdfDifferencesFinder;
import eu.europa.esig.dss.pdf.modifications.PdfModification;
import eu.europa.esig.dss.pdf.modifications.PdfModificationDetection;
import eu.europa.esig.dss.pdf.modifications.PdfObjectModificationsFinder;
import eu.europa.esig.dss.pdf.visible.ImageRotationUtils;
import eu.europa.esig.dss.pdf.visible.SignatureDrawer;
import eu.europa.esig.dss.pdf.visible.SignatureDrawerFactory;
import eu.europa.esig.dss.pdf.visible.SignatureFieldBoxBuilder;
import eu.europa.esig.dss.pdf.visible.VisualSignatureFieldAppearance;
import eu.europa.esig.dss.signature.resources.DSSResourcesHandler;
import eu.europa.esig.dss.signature.resources.DSSResourcesHandlerBuilder;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPDFSignatureService
implements PDFSignatureService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPDFSignatureService.class);
    private final PDFServiceMode serviceMode;
    private final SignatureDrawerFactory signatureDrawerFactory;
    protected DSSResourcesHandlerBuilder resourcesHandlerBuilder = PAdESUtils.DEFAULT_RESOURCES_HANDLER_BUILDER;
    protected PdfDifferencesFinder pdfDifferencesFinder = new DefaultPdfDifferencesFinder();
    protected PdfObjectModificationsFinder pdfObjectModificationsFinder = new DefaultPdfObjectModificationsFinder();
    protected PdfPermissionsChecker pdfPermissionsChecker = new PdfPermissionsChecker();
    protected PdfSignatureFieldPositionChecker pdfSignatureFieldPositionChecker = new PdfSignatureFieldPositionChecker();
    protected PdfMemoryUsageSetting pdfMemoryUsageSetting = PAdESUtils.DEFAULT_PDF_MEMORY_USAGE_SETTING;

    protected AbstractPDFSignatureService(PDFServiceMode serviceMode, SignatureDrawerFactory signatureDrawerFactory) {
        Objects.requireNonNull(serviceMode, "The PDFServiceMode shall be defined!");
        Objects.requireNonNull(signatureDrawerFactory, "The SignatureDrawerFactory shall be defined!");
        this.serviceMode = serviceMode;
        this.signatureDrawerFactory = signatureDrawerFactory;
    }

    @Override
    public void setResourcesHandlerBuilder(DSSResourcesHandlerBuilder resourcesHandlerBuilder) {
        Objects.requireNonNull(resourcesHandlerBuilder, "DSSResourcesFactoryBuilder cannot be null!");
        this.resourcesHandlerBuilder = resourcesHandlerBuilder;
    }

    @Override
    public void setPdfDifferencesFinder(PdfDifferencesFinder pdfDifferencesFinder) {
        Objects.requireNonNull(pdfDifferencesFinder, "PdfDifferencesFinder cannot be null!");
        this.pdfDifferencesFinder = pdfDifferencesFinder;
    }

    @Override
    public void setPdfObjectModificationsFinder(PdfObjectModificationsFinder pdfObjectModificationsFinder) {
        Objects.requireNonNull(pdfObjectModificationsFinder, "PdfObjectModificationsFinder cannot be null!");
        this.pdfObjectModificationsFinder = pdfObjectModificationsFinder;
    }

    @Override
    public void setPdfPermissionsChecker(PdfPermissionsChecker pdfPermissionsChecker) {
        Objects.requireNonNull(pdfPermissionsChecker, "PdfPermissionsChecker cannot be null!");
        this.pdfPermissionsChecker = pdfPermissionsChecker;
    }

    @Override
    public void setPdfSignatureFieldPositionChecker(PdfSignatureFieldPositionChecker pdfSignatureFieldPositionChecker) {
        Objects.requireNonNull(pdfSignatureFieldPositionChecker, "PdfSignatureFieldPositionChecker cannot be null!");
        this.pdfSignatureFieldPositionChecker = pdfSignatureFieldPositionChecker;
    }

    @Override
    public void setPdfMemoryUsageSetting(PdfMemoryUsageSetting pdfMemoryUsageSetting) {
        Objects.requireNonNull(pdfMemoryUsageSetting, "PdfMemoryUsageSetting cannot be null!");
        this.pdfMemoryUsageSetting = pdfMemoryUsageSetting;
    }

    protected SignatureDrawer loadSignatureDrawer(SignatureImageParameters imageParameters) {
        SignatureDrawer signatureDrawer = this.signatureDrawerFactory.getSignatureDrawer(imageParameters);
        if (signatureDrawer == null) {
            throw new IllegalArgumentException("SignatureDrawer shall be defined for the used SignatureDrawerFactory!");
        }
        return signatureDrawer;
    }

    protected DSSResourcesHandler instantiateResourcesHandler() throws IOException {
        return this.resourcesHandlerBuilder.createResourcesHandler();
    }

    @Override
    public DSSMessageDigest messageDigest(DSSDocument toSignDocument, PAdESCommonParameters parameters) {
        Objects.requireNonNull(toSignDocument, "DSSDocument shall be provided!");
        Objects.requireNonNull(parameters, "PAdESCommonParameters cannot be null!");
        PdfSignatureCache pdfSignatureCache = parameters.getPdfSignatureCache();
        if (pdfSignatureCache.getMessageDigest() == null) {
            DSSMessageDigest messageDigest = this.computeDigest(toSignDocument, parameters);
            pdfSignatureCache.setMessageDigest(messageDigest);
        }
        return pdfSignatureCache.getMessageDigest();
    }

    protected abstract DSSMessageDigest computeDigest(DSSDocument var1, PAdESCommonParameters var2);

    @Override
    public DSSDocument sign(DSSDocument toSignDocument, byte[] cmsSignedData, PAdESCommonParameters parameters) {
        Objects.requireNonNull(toSignDocument, "DSSDocument shall be provided!");
        Objects.requireNonNull(cmsSignedData, "CMSSignedData cannot be null!");
        Objects.requireNonNull(parameters, "PAdESCommonParameters cannot be null!");
        PdfSignatureCache pdfSignatureCache = parameters.getPdfSignatureCache();
        DSSDocument signedDocument = null;
        if (pdfSignatureCache.getToBeSignedDocument() != null) {
            try {
                signedDocument = PAdESUtils.replaceSignature(pdfSignatureCache.getToBeSignedDocument(), cmsSignedData, this.resourcesHandlerBuilder);
            }
            catch (Exception e) {
                String errorMessage = "Unable to sign document using a resources caching! Reason : '{}'. Sign using a complete processing...";
                if (LOG.isDebugEnabled()) {
                    LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                }
                LOG.warn(errorMessage, (Object)e.getMessage());
            }
        }
        parameters.reinit();
        if (signedDocument == null) {
            signedDocument = this.signDocument(toSignDocument, cmsSignedData, parameters);
        }
        signedDocument.setMimeType((MimeType)MimeTypeEnum.PDF);
        return signedDocument;
    }

    protected abstract DSSDocument signDocument(DSSDocument var1, byte[] var2, PAdESCommonParameters var3);

    protected boolean isDocumentTimestampLayer() {
        return PDFServiceMode.SIGNATURE_TIMESTAMP == this.serviceMode || PDFServiceMode.ARCHIVE_TIMESTAMP == this.serviceMode;
    }

    protected String getType() {
        if (this.isDocumentTimestampLayer()) {
            return "DocTimeStamp";
        }
        return "Sig";
    }

    protected void digitalSignatureEnhancement(PdfDocumentReader documentReader, PAdESCommonParameters parameters) {
        if (this.isDocumentTimestampLayer()) {
            this.ensureESICDeveloperExtension1(documentReader);
        }
        if (this.isCAdESDetached(parameters)) {
            this.ensureESICDeveloperExtension2(documentReader);
        }
        if (this.isISO_32001(parameters)) {
            this.ensureISO_32001DeveloperExtension(documentReader);
        }
        if (this.isISO_32002(parameters)) {
            this.ensureISO_32002DeveloperExtension(documentReader);
        }
    }

    protected void ensureESICDeveloperExtension1(PdfDocumentReader documentReader) {
        if (documentReader.getPdfHeaderVersion() < 1.7f || documentReader.getVersion() < 1.7f) {
            return;
        }
        if (documentReader.getVersion() >= 2.0f) {
            return;
        }
        PdfDict esicExtension = this.createDeveloperExtensionDict(documentReader, "1.7", 1, null, null, null);
        PdfDict adbeExtension = this.createDeveloperExtensionDict(documentReader, "1.7", 8, null, null, null);
        if (!this.isDeveloperExtensionPresent(documentReader, "ESIC", esicExtension) && !this.isDeveloperExtensionPresent(documentReader, "ADBE", adbeExtension)) {
            this.addDeveloperExtension(documentReader, "ADBE", adbeExtension);
        }
    }

    protected void ensureESICDeveloperExtension2(PdfDocumentReader documentReader) {
        if (documentReader.getPdfHeaderVersion() < 1.7f || documentReader.getVersion() < 1.7f) {
            return;
        }
        if (documentReader.getVersion() >= 2.0f) {
            return;
        }
        PdfDict esicExtension = this.createDeveloperExtensionDict(documentReader, "1.7", 2, null, null, null);
        PdfDict adbeExtension = this.createDeveloperExtensionDict(documentReader, "1.7", 8, null, null, null);
        if (!this.isDeveloperExtensionPresent(documentReader, "ESIC", esicExtension) && !this.isDeveloperExtensionPresent(documentReader, "ADBE", adbeExtension)) {
            this.addDeveloperExtension(documentReader, "ADBE", adbeExtension);
        }
    }

    protected void ensureISO_32001DeveloperExtension(PdfDocumentReader documentReader) {
        if (documentReader.getPdfHeaderVersion() < 2.0f || documentReader.getVersion() < 2.0f) {
            return;
        }
        PdfDict developerExtension = this.createDeveloperExtensionDict(documentReader, "2.0", 32001, ":2022", "DeveloperExtensions", "https://www.iso.org/standard/45874.html");
        if (!this.isDeveloperExtensionPresent(documentReader, "ISO_", developerExtension)) {
            this.addDeveloperExtension(documentReader, "ISO_", developerExtension);
        }
    }

    protected void ensureISO_32002DeveloperExtension(PdfDocumentReader documentReader) {
        if (documentReader.getPdfHeaderVersion() < 2.0f || documentReader.getVersion() < 2.0f) {
            return;
        }
        PdfDict developerExtension = this.createDeveloperExtensionDict(documentReader, "2.0", 32002, ":2022", "DeveloperExtensions", "https://www.iso.org/standard/45875.html");
        if (!this.isDeveloperExtensionPresent(documentReader, "ISO_", developerExtension)) {
            this.addDeveloperExtension(documentReader, "ISO_", developerExtension);
        }
    }

    protected PdfDict createDeveloperExtensionDict(PdfDocumentReader documentReader, String baseVersion, Integer extensionLevel, String extensionRevision, String type, String url) {
        PdfDict pdfDict = documentReader.createPdfDict();
        if (baseVersion != null) {
            pdfDict.setNameValue("BaseVersion", baseVersion);
        }
        if (extensionLevel != null) {
            pdfDict.setIntegerValue("ExtensionLevel", extensionLevel);
        }
        if (extensionRevision != null) {
            pdfDict.setStringValue("ExtensionRevision", extensionRevision);
        }
        if (type != null) {
            pdfDict.setNameValue("Type", type);
        }
        if (url != null) {
            pdfDict.setStringValue("URL", url);
        }
        return pdfDict;
    }

    protected boolean isCAdESDetached(PAdESCommonParameters parameters) {
        return "ETSI.CAdES.detached".equals(parameters.getSubFilter());
    }

    protected boolean isISO_32001(PAdESCommonParameters parameters) {
        return !(!"adbe.pkcs7.detached".equals(parameters.getSubFilter()) && !"ETSI.CAdES.detached".equals(parameters.getSubFilter()) && !"ETSI.RFC3161".equals(parameters.getSubFilter()) || DigestAlgorithm.SHA3_256 != parameters.getDigestAlgorithm() && DigestAlgorithm.SHA3_384 != parameters.getDigestAlgorithm() && DigestAlgorithm.SHA3_512 != parameters.getDigestAlgorithm() && DigestAlgorithm.SHAKE256 != parameters.getDigestAlgorithm());
    }

    protected boolean isISO_32002(PAdESCommonParameters parameters) {
        return !(!"adbe.pkcs7.detached".equals(parameters.getSubFilter()) && !"ETSI.CAdES.detached".equals(parameters.getSubFilter()) && !"ETSI.RFC3161".equals(parameters.getSubFilter()) || EncryptionAlgorithm.EDDSA != parameters.getEncryptionAlgorithm() || DigestAlgorithm.SHA512 != parameters.getDigestAlgorithm() && DigestAlgorithm.SHAKE256 != parameters.getDigestAlgorithm());
    }

    protected boolean isDeveloperExtensionPresent(PdfDocumentReader documentReader, String prefix, PdfDict developerExtension) {
        PdfDict catalogDict = documentReader.getCatalogDictionary();
        PdfDict extensionsDict = catalogDict.getAsDict("Extensions");
        if (extensionsDict != null) {
            if (extensionsDict.getAsArray(prefix) != null) {
                PdfArray extensionDictArray = extensionsDict.getAsArray(prefix);
                for (int i = 0; i < extensionDictArray.size(); ++i) {
                    PdfDict extensionDict = extensionDictArray.getAsDict(i);
                    if (extensionDict == null || !extensionDict.match(developerExtension)) continue;
                    return true;
                }
            } else if (extensionsDict.getAsDict(prefix) != null && extensionsDict.getAsDict(prefix).match(developerExtension)) {
                return true;
            }
        }
        return false;
    }

    protected void addDeveloperExtension(PdfDocumentReader documentReader, String prefix, PdfDict developerExtension) {
        PdfDict catalogDict = documentReader.getCatalogDictionary();
        PdfDict extensionsDict = catalogDict.getAsDict("Extensions");
        if (extensionsDict == null) {
            extensionsDict = documentReader.createPdfDict();
            extensionsDict.setDirect(true);
            catalogDict.setPdfObjectValue("Extensions", extensionsDict);
        }
        PdfArray extensionDictArray = extensionsDict.getAsArray(prefix);
        PdfDict existingDictionary = extensionsDict.getAsDict(prefix);
        if (existingDictionary != null) {
            extensionDictArray = documentReader.createPdfArray();
            existingDictionary.setDirect(false);
            extensionDictArray.addObject(existingDictionary);
            extensionsDict.setPdfObjectValue(prefix, extensionDictArray);
        }
        if (extensionDictArray != null) {
            extensionDictArray.addObject(developerExtension);
        } else {
            developerExtension.setDirect(true);
            extensionsDict.setPdfObjectValue(prefix, developerExtension);
        }
    }

    @Override
    public List<PdfRevision> getRevisions(DSSDocument document, char[] pwd) {
        Objects.requireNonNull(document, "DSSDocument shall be provided!");
        ArrayList<PdfRevision> revisions = new ArrayList<PdfRevision>();
        List<PdfByteRangeDocument> revisionDocuments = PAdESUtils.extractRevisions(document);
        try (PdfDocumentReader reader = this.loadPdfDocumentReader(document, pwd);){
            PdfDssDict dssDictionary;
            PdfCompositeDssDictionary compositeDssDictionary = new PdfCompositeDssDictionary();
            PdfDssDict lastDSSDictionary = dssDictionary = reader.getDSSDictionary();
            compositeDssDictionary.populateFromDssDictionary(lastDSSDictionary);
            Map<PdfSignatureDictionary, List<PdfSignatureField>> sigDictionaries = reader.extractSigDictionaries();
            sigDictionaries = this.sortSignatureDictionaries(sigDictionaries);
            for (Map.Entry<PdfSignatureDictionary, List<PdfSignatureField>> sigDictEntry : sigDictionaries.entrySet()) {
                PdfSignatureDictionary signatureDictionary = sigDictEntry.getKey();
                List<PdfSignatureField> fields = sigDictEntry.getValue();
                List<String> fieldNames = this.toStringNames(fields);
                try {
                    boolean signatureCoversWholeDocument;
                    Object signedContent;
                    ByteRange byteRange;
                    block36: {
                        LOG.info("Signature fields: {}", fieldNames);
                        byteRange = signatureDictionary.getByteRange();
                        byte[] cms = signatureDictionary.getContents();
                        boolean byteRangeValid = this.validateByteRange(byteRange, document, cms);
                        byteRange.setValid(byteRangeValid);
                        signedContent = null;
                        if (byteRange.isValid() && !this.isSignedContentComplete(byteRange, (DSSDocument)(signedContent = new PdfByteRangeDocument(document, byteRange)))) {
                            byteRange.setValid(false);
                        }
                        if (!byteRange.isValid()) {
                            signedContent = InMemoryDocument.createEmptyDocument();
                            LOG.warn("The signature '{}' has an invalid /ByteRange! The validation will result to a broken signature.", fieldNames);
                        }
                        signatureCoversWholeDocument = reader.isSignatureCoversWholeDocument(signatureDictionary);
                        DSSDocument revisionContent = PAdESUtils.getRevisionContent(document, byteRange);
                        try (PdfDocumentReader revisionReader = this.loadPdfDocumentReader(revisionContent, pwd);){
                            this.verifyPdfSignatureDictionary(signatureDictionary, fieldNames, revisionReader);
                            lastDSSDictionary = this.getPreviousDssDictAndUpdateIfNeeded(revisions, compositeDssDictionary, lastDSSDictionary, revisionReader.getDSSDictionary());
                        }
                        catch (Exception e) {
                            if (!LOG.isDebugEnabled()) break block36;
                            LOG.debug("Cannot read signature revision '{}' : {}", fieldNames, (Object)e.getMessage());
                        }
                    }
                    DSSDocument previousRevision = PAdESUtils.getPreviousRevision(byteRange, revisionDocuments);
                    PdfCMSRevision newRevision = null;
                    if (this.isDocTimestamp(signatureDictionary)) {
                        newRevision = new PdfDocTimestampRevision(signatureDictionary, fields, (DSSDocument)signedContent, previousRevision, signatureCoversWholeDocument);
                    } else if (this.isSignature(signatureDictionary)) {
                        newRevision = new PdfSignatureRevision(signatureDictionary, compositeDssDictionary, this.containsDSSRevisions(revisions) ? dssDictionary : null, fields, (DSSDocument)signedContent, previousRevision, signatureCoversWholeDocument);
                    } else {
                        LOG.warn("The entry {} is skipped. A signature dictionary entry with a type '{}' and subFilter '{}' is not acceptable configuration!", new Object[]{fieldNames, signatureDictionary.getType(), signatureDictionary.getSubFilter()});
                    }
                    if (newRevision != null) {
                        revisions.add(newRevision);
                    }
                    try {
                        PdfDocumentReader revisionReader = this.loadPdfDocumentReader(previousRevision, pwd);
                        try {
                            lastDSSDictionary = this.getPreviousDssDictAndUpdateIfNeeded(revisions, compositeDssDictionary, lastDSSDictionary, revisionReader.getDSSDictionary());
                        }
                        finally {
                            if (revisionReader == null) continue;
                            revisionReader.close();
                        }
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Exception e) {
                    String errorMessage = "Unable to parse signature {} . Reason : {}";
                    if (LOG.isDebugEnabled()) {
                        LOG.warn(errorMessage, new Object[]{fieldNames, e.getMessage(), e});
                        continue;
                    }
                    LOG.warn(errorMessage, fieldNames, (Object)e.getMessage());
                }
            }
        }
        catch (IOException e) {
            throw new DSSException(String.format("The document with name [%s] is either not accessible or not PDF compatible. Reason : [%s]", document.getName(), e.getMessage()), (Throwable)e);
        }
        catch (DSSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DSSException("Cannot analyze signatures : " + e.getMessage(), (Throwable)e);
        }
        return revisions;
    }

    @Override
    public DSSDocument addDssDictionary(DSSDocument document, PdfValidationDataContainer validationDataForInclusion) {
        return this.addDssDictionary(document, validationDataForInclusion, null);
    }

    @Override
    public DSSDocument addDssDictionary(DSSDocument document, PdfValidationDataContainer validationDataForInclusion, char[] pwd) {
        return this.addDssDictionary(document, validationDataForInclusion, pwd, false);
    }

    @Override
    public List<String> getAvailableSignatureFields(DSSDocument document) {
        return this.getAvailableSignatureFields(document, null);
    }

    @Override
    public DSSDocument addNewSignatureField(DSSDocument document, SignatureFieldParameters parameters) {
        return this.addNewSignatureField(document, parameters, null);
    }

    protected abstract PdfDocumentReader loadPdfDocumentReader(DSSDocument var1, char[] var2) throws IOException, InvalidPasswordException;

    private Map<PdfSignatureDictionary, List<PdfSignatureField>> sortSignatureDictionaries(Map<PdfSignatureDictionary, List<PdfSignatureField>> pdfSignatureDictionary) {
        return pdfSignatureDictionary.entrySet().stream().sorted(Map.Entry.comparingByKey(new PdfSignatureDictionaryComparator()).reversed()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
    }

    private void verifyPdfSignatureDictionary(PdfSignatureDictionary signatureDictionary, List<String> fieldNames, PdfDocumentReader revisionReader) throws IOException {
        PdfSignatureDictionary signatureDictionaryToCompare = this.getSignatureDictionaryForFieldNames(fieldNames, revisionReader);
        if (!signatureDictionary.checkConsistency(signatureDictionaryToCompare)) {
            LOG.warn("The signature dictionary for signature {} is not consistent!", fieldNames);
        }
    }

    private PdfSignatureDictionary getSignatureDictionaryForFieldNames(List<String> fieldNames, PdfDocumentReader revisionReader) throws IOException {
        Map<PdfSignatureDictionary, List<PdfSignatureField>> pdfSignatureDictionaryListMap = revisionReader.extractSigDictionaries();
        for (Map.Entry<PdfSignatureDictionary, List<PdfSignatureField>> entry : pdfSignatureDictionaryListMap.entrySet()) {
            PdfSignatureDictionary signatureDictionary = entry.getKey();
            List<PdfSignatureField> signatureFields = entry.getValue();
            if (!fieldNames.equals(this.toStringNames(signatureFields))) continue;
            return signatureDictionary;
        }
        return null;
    }

    private List<String> toStringNames(List<PdfSignatureField> signatureFields) {
        return signatureFields.stream().map(PdfSignatureField::getFieldName).collect(Collectors.toList());
    }

    private PdfDssDict getPreviousDssDictAndUpdateIfNeeded(List<PdfRevision> revisions, PdfCompositeDssDictionary compositeDssDictionary, PdfDssDict lastDSSDictionary, PdfDssDict currentDssDict) {
        if (lastDSSDictionary != null && !lastDSSDictionary.equals(currentDssDict)) {
            compositeDssDictionary.populateFromDssDictionary(lastDSSDictionary);
            revisions.add(new PdfDocDssRevision(compositeDssDictionary, lastDSSDictionary));
        }
        return currentDssDict;
    }

    private boolean containsDSSRevisions(List<PdfRevision> revisions) {
        return revisions.stream().anyMatch(PdfDocDssRevision.class::isInstance);
    }

    protected boolean validateByteRange(ByteRange byteRange, DSSDocument document, byte[] cms) {
        try {
            byteRange.validate();
            if (!this.isContentValueEqualsByteRangeExtraction(byteRange, document, cms)) {
                LOG.warn("Signature with the /ByteRange '{}' is invalid. SIWA detected!", (Object)byteRange);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            String message = String.format("/ByteRange validation ended with error : %s. Reason : %s", byteRange, e.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.warn(message, (Throwable)e);
            } else {
                LOG.warn(message);
            }
            return false;
        }
    }

    private boolean isContentValueEqualsByteRangeExtraction(ByteRange byteRange, DSSDocument document, byte[] cms) {
        byte[] cmsWithByteRange = PAdESUtils.getSignatureValue(document, byteRange);
        boolean match = Arrays.equals(cms, cmsWithByteRange);
        if (!match) {
            LOG.warn("The value extracted according to /ByteRange '{}' does not match the signature present in /Contents field!", (Object)byteRange);
        }
        return match;
    }

    private boolean isSignedContentComplete(ByteRange byteRange, DSSDocument signedContent) {
        long signedContentLength;
        int expectedSignedContentLength = byteRange.getFirstPartEnd() - byteRange.getFirstPartStart() + byteRange.getSecondPartEnd();
        if ((long)expectedSignedContentLength != (signedContentLength = DSSUtils.getFileByteSize((DSSDocument)signedContent))) {
            LOG.warn("The length of the extracted signed content '{}' does not correspond to the content length defined by the ByteRange {} : {}!", new Object[]{signedContentLength, byteRange, expectedSignedContentLength});
            return false;
        }
        return true;
    }

    protected boolean isDocTimestamp(PdfSignatureDictionary pdfSigDict) {
        String type = pdfSigDict.getType();
        String subFilter = pdfSigDict.getSubFilter();
        return (type == null || "DocTimeStamp".equals(type)) && "ETSI.RFC3161".equals(subFilter);
    }

    protected boolean isSignature(PdfSignatureDictionary pdfSigDict) {
        String type = pdfSigDict.getType();
        String subFilter = pdfSigDict.getSubFilter();
        return (type == null || "Sig".equals(type)) && !"ETSI.RFC3161".equals(subFilter);
    }

    protected AnnotationBox getVisibleSignatureFieldBoxPosition(SignatureDrawer signatureDrawer, PdfDocumentReader documentReader, SignatureFieldParameters fieldParameters) throws IOException {
        AnnotationBox signatureFieldAnnotation = this.buildSignatureFieldBox(signatureDrawer);
        if (signatureFieldAnnotation != null) {
            AnnotationBox pageBox = documentReader.getPageBox(fieldParameters.getPage());
            signatureFieldAnnotation = this.toPdfPageCoordinates(signatureFieldAnnotation, pageBox);
            this.assertSignatureFieldPositionValid(documentReader, signatureFieldAnnotation, fieldParameters.getPage());
        }
        return signatureFieldAnnotation;
    }

    protected AnnotationBox buildSignatureFieldBox(SignatureDrawer signatureDrawer) throws IOException {
        SignatureFieldBoxBuilder signatureFieldBoxBuilder;
        VisualSignatureFieldAppearance signatureFieldBox;
        if (signatureDrawer instanceof SignatureFieldBoxBuilder && (signatureFieldBox = (signatureFieldBoxBuilder = (SignatureFieldBoxBuilder)((Object)signatureDrawer)).buildSignatureFieldBox()) != null) {
            return signatureFieldBox.getAnnotationBox();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("The used SignatureDrawer shall be an instance of VisibleSignatureFieldBoxBuilder in order to verify a SignatureField position!");
        }
        return null;
    }

    protected AnnotationBox getVisibleSignatureFieldBoxPosition(PdfDocumentReader reader, SignatureFieldParameters parameters) throws IOException {
        AnnotationBox originalPageBox;
        int pageRotation = reader.getPageRotation(parameters.getPage());
        int globalRotation = ImageRotationUtils.getRotation(parameters.getRotation(), pageRotation);
        AnnotationBox pageBox = originalPageBox = reader.getPageBox(parameters.getPage());
        AnnotationBox annotationBox = new AnnotationBox(parameters);
        if (ImageRotationUtils.isSwapOfDimensionsRequired(globalRotation)) {
            pageBox = ImageRotationUtils.swapDimensions(pageBox);
        }
        annotationBox = ImageRotationUtils.rotateRelativelyWrappingBox(annotationBox, pageBox, 360 - globalRotation);
        annotationBox = this.toPdfPageCoordinates(annotationBox, originalPageBox);
        this.assertSignatureFieldPositionValid(reader, annotationBox, parameters.getPage());
        return annotationBox;
    }

    protected void assertSignatureFieldPositionValid(PdfDocumentReader documentReader, AnnotationBox annotationBox, int pageNumber) {
        this.pdfSignatureFieldPositionChecker.assertSignatureFieldPositionValid(documentReader, annotationBox, pageNumber);
    }

    protected AnnotationBox toPdfPageCoordinates(AnnotationBox fieldAnnotationBox, AnnotationBox pageBox) {
        return fieldAnnotationBox.toPdfPageCoordinates(pageBox.getHeight());
    }

    @Override
    public void analyzePdfModifications(DSSDocument document, List<AdvancedSignature> signatures, char[] pwd) {
        if (Utils.isCollectionEmpty(signatures)) {
            return;
        }
        try (PdfDocumentReader finalRevisionReader = this.loadPdfDocumentReader(document, pwd);){
            for (AdvancedSignature signature : signatures) {
                PAdESSignature padesSignature = (PAdESSignature)signature;
                this.analyzePdfModifications(document, padesSignature.getPdfRevision(), finalRevisionReader, pwd);
            }
            for (TimestampToken timestampToken : this.getUniqueTimestamps(signatures)) {
                PdfTimestampToken pdfTimestampToken = (PdfTimestampToken)timestampToken;
                this.analyzePdfModifications(document, pdfTimestampToken.getPdfRevision(), finalRevisionReader, pwd);
            }
        }
        catch (Exception e) {
            String errorMessage = "Unable to proceed PDF modification detection. Reason : {}";
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
            }
            LOG.warn(errorMessage, (Object)e.getMessage());
        }
    }

    private List<TimestampToken> getUniqueTimestamps(List<AdvancedSignature> signatures) {
        ArrayList<TimestampToken> timestampTokens = new ArrayList<TimestampToken>();
        for (AdvancedSignature signature : signatures) {
            timestampTokens.addAll(signature.getDocumentTimestamps());
        }
        return timestampTokens;
    }

    @Override
    public void analyzeTimestampPdfModifications(DSSDocument document, List<TimestampToken> timestamps, char[] pwd) {
        if (Utils.isCollectionEmpty(timestamps)) {
            return;
        }
        try (PdfDocumentReader finalRevisionReader = this.loadPdfDocumentReader(document, pwd);){
            for (TimestampToken timestampToken : timestamps) {
                if (!(timestampToken instanceof PdfTimestampToken)) continue;
                PdfTimestampToken pdfTimestampToken = (PdfTimestampToken)timestampToken;
                this.analyzePdfModifications(document, pdfTimestampToken.getPdfRevision(), finalRevisionReader, pwd);
            }
        }
        catch (Exception e) {
            String errorMessage = "Unable to proceed PDF modification detection. Reason : {}";
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
            }
            LOG.warn(errorMessage, (Object)e.getMessage());
        }
    }

    protected void analyzePdfModifications(DSSDocument document, PdfCMSRevision pdfRevision, PdfDocumentReader finalRevisionReader, char[] pwd) throws IOException {
        DSSDocument revisionContent = PAdESUtils.getRevisionContent(document, pdfRevision.getByteRange());
        pdfRevision.setModificationDetection(this.getModificationDetection(finalRevisionReader, revisionContent, pwd));
    }

    private PdfModificationDetection getModificationDetection(PdfDocumentReader finalRevisionReader, DSSDocument originalDocument, char[] pwd) throws IOException {
        try (PdfDocumentReader signedRevisionReader = this.loadPdfDocumentReader(originalDocument, pwd);){
            PdfModificationDetection pdfModificationDetection = new PdfModificationDetection();
            pdfModificationDetection.setAnnotationOverlaps(this.pdfDifferencesFinder.getAnnotationOverlaps(finalRevisionReader));
            pdfModificationDetection.setPageDifferences(this.pdfDifferencesFinder.getPagesDifferences(signedRevisionReader, finalRevisionReader));
            pdfModificationDetection.setVisualDifferences(this.getVisualDifferences(signedRevisionReader, finalRevisionReader));
            pdfModificationDetection.setObjectModifications(this.pdfObjectModificationsFinder.find(signedRevisionReader, finalRevisionReader));
            PdfModificationDetection pdfModificationDetection2 = pdfModificationDetection;
            return pdfModificationDetection2;
        }
    }

    protected List<PdfModification> getVisualDifferences(PdfDocumentReader signedRevisionReader, PdfDocumentReader finalRevisionReader) {
        return this.pdfDifferencesFinder.getVisualDifferences(signedRevisionReader, finalRevisionReader);
    }

    protected void checkPdfPermissions(PdfDocumentReader documentReader, SignatureFieldParameters fieldParameters) {
        this.pdfPermissionsChecker.checkDocumentPermissions(documentReader, fieldParameters);
        if (!this.isDocumentTimestampLayer()) {
            this.pdfPermissionsChecker.checkSignatureRestrictionDictionaries(documentReader, fieldParameters);
        }
    }
}

