/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation.dss;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.pades.validation.PdfObjectKey;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfVriDict;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PdfCompositeDssDictOCSPSource
extends OfflineOCSPSource {
    private final Map<PdfObjectKey, Set<OCSPResponseBinary>> ocspBinaryByIdMap = new HashMap<PdfObjectKey, Set<OCSPResponseBinary>>();
    private final Map<EncapsulatedRevocationTokenIdentifier<OCSP>, Set<PdfObjectKey>> ocspBinaryByObjectMap = new HashMap<EncapsulatedRevocationTokenIdentifier<OCSP>, Set<PdfObjectKey>>();
    private final Map<RevocationToken<OCSP>, Set<PdfObjectKey>> ocspTokenMap = new HashMap<RevocationToken<OCSP>, Set<PdfObjectKey>>();

    public void populateFromDssDictionary(PdfDssDict dssDictionary) {
        this.extractDSSOCSPs(dssDictionary);
        this.extractVRIOCSPs(dssDictionary);
    }

    protected void extractDSSOCSPs(PdfDssDict dssDictionary) {
        Map<PdfObjectKey, OCSPResponseBinary> dssOCSPMap = dssDictionary.getOCSPs();
        this.populateObjectsMap(dssOCSPMap);
        for (OCSPResponseBinary OCSP2 : dssOCSPMap.values()) {
            this.addBinary((EncapsulatedRevocationTokenIdentifier)OCSP2, RevocationOrigin.DSS_DICTIONARY);
        }
    }

    protected void extractVRIOCSPs(PdfDssDict dssDictionary) {
        if (dssDictionary != null) {
            List<PdfVriDict> vriDictList = dssDictionary.getVRIs();
            for (PdfVriDict vriDict : vriDictList) {
                this.populateObjectsMap(vriDict.getOCSPs());
                this.extractVRIOCSPs(vriDict);
            }
        }
    }

    private void populateObjectsMap(Map<PdfObjectKey, OCSPResponseBinary> ocspMap) {
        for (Map.Entry<PdfObjectKey, OCSPResponseBinary> entry : ocspMap.entrySet()) {
            this.populateMapById(entry.getKey(), entry.getValue());
            this.populateMapByObject(entry.getKey(), entry.getValue());
        }
    }

    private void populateMapById(PdfObjectKey objectId, OCSPResponseBinary ocspBinary) {
        Set<OCSPResponseBinary> ocspBinaries = this.ocspBinaryByIdMap.get(objectId);
        if (ocspBinaries == null) {
            ocspBinaries = new HashSet<OCSPResponseBinary>();
        }
        ocspBinaries.add(ocspBinary);
        this.ocspBinaryByIdMap.put(objectId, ocspBinaries);
    }

    private void populateMapByObject(PdfObjectKey objectId, OCSPResponseBinary ocspBinary) {
        Set<PdfObjectKey> objectIds = this.ocspBinaryByObjectMap.get(ocspBinary);
        if (objectIds == null) {
            objectIds = new HashSet<PdfObjectKey>();
        }
        objectIds.add(objectId);
        this.ocspBinaryByObjectMap.put((EncapsulatedRevocationTokenIdentifier<OCSP>)ocspBinary, objectIds);
    }

    protected void extractVRIOCSPs(PdfVriDict vriDictionary) {
        if (vriDictionary != null) {
            for (Map.Entry<PdfObjectKey, OCSPResponseBinary> OCSPEntry : vriDictionary.getOCSPs().entrySet()) {
                this.addBinary((EncapsulatedRevocationTokenIdentifier)OCSPEntry.getValue(), RevocationOrigin.VRI_DICTIONARY);
            }
        }
    }

    @Deprecated
    protected Set<OCSPResponseBinary> getOCSPBinariesByObjectId(PdfObjectKey objectId) {
        return this.ocspBinaryByIdMap.get(objectId);
    }

    protected Set<PdfObjectKey> getRevocationTokenIds(RevocationToken<OCSP> ocspToken) {
        return this.ocspTokenMap.get(ocspToken);
    }

    public void addRevocation(RevocationToken<OCSP> token, EncapsulatedRevocationTokenIdentifier<OCSP> binary) {
        super.addRevocation(token, binary);
        Set<PdfObjectKey> tokenBinaryObjectIds = this.getTokenBinaryObjectIds(binary);
        this.ocspTokenMap.put(token, tokenBinaryObjectIds);
    }

    protected Set<PdfObjectKey> getTokenBinaryObjectIds(EncapsulatedRevocationTokenIdentifier<OCSP> binary) {
        return this.ocspBinaryByObjectMap.get(binary);
    }
}

