/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation.dss;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.pades.validation.PdfObjectKey;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfVriDict;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PdfCompositeDssDictCRLSource
extends OfflineCRLSource {
    private final Map<PdfObjectKey, Set<CRLBinary>> crlBinaryByIdMap = new HashMap<PdfObjectKey, Set<CRLBinary>>();
    private final Map<EncapsulatedRevocationTokenIdentifier<CRL>, Set<PdfObjectKey>> crlBinaryByObjectMap = new HashMap<EncapsulatedRevocationTokenIdentifier<CRL>, Set<PdfObjectKey>>();
    private final Map<RevocationToken<CRL>, Set<PdfObjectKey>> crlTokenMap = new HashMap<RevocationToken<CRL>, Set<PdfObjectKey>>();

    public void populateFromDssDictionary(PdfDssDict dssDictionary) {
        this.extractDSSCRLs(dssDictionary);
        this.extractVRICRLs(dssDictionary);
    }

    protected void extractDSSCRLs(PdfDssDict dssDictionary) {
        Map<PdfObjectKey, CRLBinary> dssCrlMap = dssDictionary.getCRLs();
        this.populateObjectsMap(dssCrlMap);
        for (CRLBinary crl : dssCrlMap.values()) {
            this.addBinary((EncapsulatedRevocationTokenIdentifier)crl, RevocationOrigin.DSS_DICTIONARY);
        }
    }

    protected void extractVRICRLs(PdfDssDict dssDictionary) {
        if (dssDictionary != null) {
            List<PdfVriDict> vriDictList = dssDictionary.getVRIs();
            for (PdfVriDict vriDict : vriDictList) {
                this.populateObjectsMap(vriDict.getCRLs());
                this.extractVRICRLs(vriDict);
            }
        }
    }

    private void populateObjectsMap(Map<PdfObjectKey, CRLBinary> crlMap) {
        for (Map.Entry<PdfObjectKey, CRLBinary> entry : crlMap.entrySet()) {
            this.populateMapById(entry.getKey(), entry.getValue());
            this.populateMapByObject(entry.getKey(), entry.getValue());
        }
    }

    private void populateMapById(PdfObjectKey objectId, CRLBinary crlBinary) {
        Set<CRLBinary> crlBinaries = this.crlBinaryByIdMap.get(objectId);
        if (crlBinaries == null) {
            crlBinaries = new HashSet<CRLBinary>();
        }
        crlBinaries.add(crlBinary);
        this.crlBinaryByIdMap.put(objectId, crlBinaries);
    }

    private void populateMapByObject(PdfObjectKey objectId, CRLBinary crlBinary) {
        Set<PdfObjectKey> objectIds = this.crlBinaryByObjectMap.get(crlBinary);
        if (objectIds == null) {
            objectIds = new HashSet<PdfObjectKey>();
        }
        objectIds.add(objectId);
        this.crlBinaryByObjectMap.put((EncapsulatedRevocationTokenIdentifier<CRL>)crlBinary, objectIds);
    }

    protected void extractVRICRLs(PdfVriDict vriDictionary) {
        if (vriDictionary != null) {
            for (Map.Entry<PdfObjectKey, CRLBinary> crlEntry : vriDictionary.getCRLs().entrySet()) {
                this.addBinary((EncapsulatedRevocationTokenIdentifier)crlEntry.getValue(), RevocationOrigin.VRI_DICTIONARY);
            }
        }
    }

    @Deprecated
    protected Set<CRLBinary> getCRLBinariesByObjectId(PdfObjectKey objectId) {
        return this.crlBinaryByIdMap.get(objectId);
    }

    protected Set<PdfObjectKey> getRevocationTokenIds(RevocationToken<CRL> crlToken) {
        return this.crlTokenMap.get(crlToken);
    }

    public void addRevocation(RevocationToken<CRL> token, EncapsulatedRevocationTokenIdentifier<CRL> binary) {
        super.addRevocation(token, binary);
        Set<PdfObjectKey> tokenBinaryObjectIds = this.getTokenBinaryObjectIds(binary);
        this.crlTokenMap.put(token, tokenBinaryObjectIds);
    }

    protected Set<PdfObjectKey> getTokenBinaryObjectIds(EncapsulatedRevocationTokenIdentifier<CRL> binary) {
        return this.crlBinaryByObjectMap.get(binary);
    }
}

