/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.cades.validation.CAdESCertificateSource;
import eu.europa.esig.dss.enumerations.CertificateOrigin;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.pades.validation.PdfObjectKey;
import eu.europa.esig.dss.pades.validation.dss.PdfDssDictCertificateSource;
import eu.europa.esig.dss.pdf.PdfSignatureRevision;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bouncycastle.cms.SignerInformation;

public class PAdESCertificateSource
extends CAdESCertificateSource {
    private final PdfDssDictCertificateSource dssDictionaryCertificateSource;

    public PAdESCertificateSource(PdfSignatureRevision pdfSignatureRevision, String vriDictionaryName, SignerInformation signerInformation) {
        super(pdfSignatureRevision.getCMSSignedData(), signerInformation);
        Objects.requireNonNull(vriDictionaryName, "vriDictionaryName cannot be null!");
        this.dssDictionaryCertificateSource = new PdfDssDictCertificateSource(pdfSignatureRevision.getCompositeDssDictionary().getCertificateSource(), pdfSignatureRevision.getDssDictionary(), vriDictionaryName);
        this.extractFromDssDictSource();
    }

    private void extractFromDssDictSource() {
        for (CertificateToken certToken : this.getDSSDictionaryCertValues()) {
            this.addCertificate(certToken, CertificateOrigin.DSS_DICTIONARY);
        }
        for (CertificateToken certToken : this.getVRIDictionaryCertValues()) {
            this.addCertificate(certToken, CertificateOrigin.VRI_DICTIONARY);
        }
    }

    public Map<PdfObjectKey, CertificateToken> getCertificateMap() {
        return this.dssDictionaryCertificateSource.getCertificateMap();
    }

    public List<CertificateToken> getCertificateValues() {
        return Collections.emptyList();
    }

    public List<CertificateRef> getCompleteCertificateRefs() {
        return Collections.emptyList();
    }

    public List<CertificateRef> getAttributeCertificateRefs() {
        return Collections.emptyList();
    }

    public List<CertificateToken> getDSSDictionaryCertValues() {
        return this.dssDictionaryCertificateSource.getDSSDictionaryCertValues();
    }

    public List<CertificateToken> getVRIDictionaryCertValues() {
        return this.dssDictionaryCertificateSource.getVRIDictionaryCertValues();
    }
}

