/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.pades.validation.ByteRange;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class ByteRangeInputStream
extends FilterInputStream {
    private final ByteRange byteRange;
    private int position = 0;

    public ByteRangeInputStream(InputStream is, ByteRange byteRange) {
        super(is);
        Objects.requireNonNull(is, "InputStream cannot be null!");
        Objects.requireNonNull(byteRange, "ByteRange cannot be null!");
        this.byteRange = byteRange;
    }

    @Override
    public int read() throws IOException {
        this.ensureFirstByteRangePosition();
        int b = -1;
        if (this.position == this.byteRange.getFirstPartEnd()) {
            int offset = this.byteRange.getSecondPartStart() - this.byteRange.getFirstPartEnd();
            this.skip(offset);
        } else if (this.position < this.byteRange.getFirstPartStart()) {
            int offset = this.byteRange.getFirstPartStart() - this.position;
            this.skip(offset);
        }
        if (this.isPositionWithinRange(this.position + 1) && (b = super.read()) != -1) {
            ++this.position;
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Objects.requireNonNull(b, "Byte array cannot be null!");
        this.ensureFirstByteRangePosition();
        int totalRead = 0;
        while (totalRead < len) {
            int readBytes;
            int remaining = len - totalRead;
            int toRead = this.remainingBytesInCurrentPart();
            if (toRead <= 0 || (readBytes = super.read(b, off + totalRead, Math.min(remaining, toRead))) < 1) break;
            totalRead += readBytes;
            this.position += readBytes;
        }
        if (totalRead < 1) {
            return -1;
        }
        return totalRead;
    }

    private long ensureFirstByteRangePosition() throws IOException {
        return this.skip(0L);
    }

    @Override
    public long skip(long n) throws IOException {
        long finalPosition = (long)this.position + n;
        long offset = finalPosition >= (long)(this.byteRange.getFirstPartStart() + this.byteRange.getFirstPartEnd()) && finalPosition < (long)this.byteRange.getSecondPartStart() ? (long)this.byteRange.getSecondPartStart() + n - (long)this.byteRange.getFirstPartStart() - (long)this.byteRange.getFirstPartEnd() : (this.position < this.byteRange.getFirstPartStart() ? (long)(this.byteRange.getFirstPartStart() - this.position) + n : n);
        long skipped = super.skip(offset);
        if (skipped > offset) {
            skipped = offset;
        }
        this.position += (int)skipped;
        return skipped;
    }

    private boolean isPositionWithinRange(int position) {
        return this.isPositionWithinFirstPart(position) || this.isPositionWithinSecondPart(position);
    }

    private boolean isPositionWithinFirstPart(int position) {
        return position >= this.byteRange.getFirstPartStart() && position <= this.byteRange.getFirstPartStart() + this.byteRange.getFirstPartEnd();
    }

    private boolean isPositionWithinSecondPart(int position) {
        return position >= this.byteRange.getSecondPartStart() && position <= this.byteRange.getSecondPartStart() + this.byteRange.getSecondPartEnd();
    }

    private int remainingBytesInCurrentPart() {
        if (this.isPositionWithinFirstPart(this.position)) {
            return this.byteRange.getFirstPartStart() + this.byteRange.getFirstPartEnd() - this.position;
        }
        if (this.isPositionWithinSecondPart(this.position)) {
            return this.byteRange.getSecondPartStart() + this.byteRange.getSecondPartEnd() - this.position;
        }
        return 0;
    }
}

