/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature;

import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.signature.AbstractSignatureParameters;
import eu.europa.esig.dss.signature.SignatureRequirementsChecker;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.status.SignatureStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PAdESSignatureRequirementsChecker
extends SignatureRequirementsChecker {
    private static final Logger LOG = LoggerFactory.getLogger(PAdESSignatureRequirementsChecker.class);

    public PAdESSignatureRequirementsChecker(CertificateVerifier certificateVerifier, PAdESSignatureParameters signatureParameters) {
        super(certificateVerifier, (AbstractSignatureParameters)signatureParameters);
    }

    protected void checkTLevelIsHighest(AdvancedSignature signature, SignatureStatus status) {
        if (signature.hasLTAProfile()) {
            status.addRelatedTokenAndErrorMessage(signature, "The signature is already extended with a higher level.");
        } else if (signature.hasLTProfile() && !signature.areAllSelfSignedCertificates()) {
            if (signature.hasTProfile()) {
                status.addRelatedTokenAndErrorMessage(signature, "The signature is already extended with a higher level.");
            }
            LOG.info("Signature contains a DSS dictionary, but no associated timestamp. Extension may lead to LTA-level.");
        }
    }
}

