/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature;

import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.signature.PAdESLevelBaselineT;
import eu.europa.esig.dss.pades.signature.PAdESSignatureRequirementsChecker;
import eu.europa.esig.dss.pades.validation.PDFDocumentAnalyzer;
import eu.europa.esig.dss.pades.validation.PdfValidationDataContainer;
import eu.europa.esig.dss.pdf.IPdfObjFactory;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.ValidationDataContainer;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import java.util.Collection;
import java.util.List;

class PAdESLevelBaselineLT
extends PAdESLevelBaselineT {
    PAdESLevelBaselineLT(TSPSource tspSource, CertificateVerifier certificateVerifier, IPdfObjFactory pdfObjectFactory) {
        super(tspSource, certificateVerifier, pdfObjectFactory);
    }

    @Override
    protected DSSDocument extendSignatures(DSSDocument document, PDFDocumentAnalyzer pdfDocumentAnalyzer, PAdESSignatureParameters parameters) {
        boolean tLevelAdded;
        DSSDocument extendedDocument = super.extendSignatures(document, pdfDocumentAnalyzer, parameters);
        boolean bl = tLevelAdded = extendedDocument != document;
        if (tLevelAdded) {
            pdfDocumentAnalyzer = this.getPDFDocumentValidator(extendedDocument, parameters);
        }
        List signatures = pdfDocumentAnalyzer.getSignatures();
        PAdESSignatureRequirementsChecker signatureRequirementsChecker = new PAdESSignatureRequirementsChecker(this.certificateVerifier, parameters);
        if (!tLevelAdded && SignatureLevel.PAdES_BASELINE_LT.equals((Object)parameters.getSignatureLevel())) {
            signatureRequirementsChecker.assertExtendToLTLevelPossible(signatures);
        }
        signatureRequirementsChecker.assertSignaturesValid(signatures);
        signatureRequirementsChecker.assertCertificateChainValidForLTLevel(signatures);
        List<TimestampToken> detachedTimestamps = pdfDocumentAnalyzer.getDetachedTimestamps();
        ValidationDataContainer validationData = pdfDocumentAnalyzer.getValidationData((Collection)signatures, detachedTimestamps);
        PDFSignatureService signatureService = this.getPAdESSignatureService();
        return signatureService.addDssDictionary(extendedDocument, (PdfValidationDataContainer)validationData, parameters.getPasswordProtection(), parameters.isIncludeVRIDictionary());
    }

    private PDFSignatureService getPAdESSignatureService() {
        return this.pdfObjectFactory.newPAdESSignatureService();
    }
}

