/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.openpdf.visible;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfSignatureAppearance;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pdf.AnnotationBox;
import eu.europa.esig.dss.pdf.openpdf.visible.ITextSignatureDrawer;
import eu.europa.esig.dss.pdf.visible.DSSFontMetrics;
import eu.europa.esig.dss.pdf.visible.ImageRotationUtils;
import eu.europa.esig.dss.pdf.visible.SignatureFieldBoxBuilder;
import eu.europa.esig.dss.pdf.visible.SignatureFieldDimensionAndPosition;
import eu.europa.esig.dss.pdf.visible.SignatureFieldDimensionAndPositionBuilder;
import eu.europa.esig.dss.utils.Utils;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractITextSignatureDrawer
implements ITextSignatureDrawer,
SignatureFieldBoxBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractITextSignatureDrawer.class);
    private PdfReader reader;
    protected SignatureImageParameters parameters;
    protected PdfSignatureAppearance appearance;

    protected AbstractITextSignatureDrawer() {
    }

    @Override
    public void init(SignatureImageParameters parameters, PdfReader reader, PdfSignatureAppearance appearance) {
        this.parameters = parameters;
        this.reader = reader;
        this.appearance = appearance;
        this.checkColorSpace(reader);
    }

    public SignatureFieldDimensionAndPosition buildSignatureFieldBox() {
        AnnotationBox pageBox = this.getPageAnnotationBox();
        int pageRotation = this.getPageRotation();
        return new SignatureFieldDimensionAndPositionBuilder(this.parameters, this.getDSSFontMetrics(), pageBox, pageRotation).setSignatureFieldAnnotationBox(this.getSignatureFieldAnnotationBox()).build();
    }

    protected abstract DSSFontMetrics getDSSFontMetrics();

    protected AnnotationBox getPageAnnotationBox() {
        int pageNumber = this.parameters.getFieldParameters().getPage();
        Rectangle rectangle = this.reader.getPageSize(pageNumber);
        return new AnnotationBox(0.0f, 0.0f, rectangle.getWidth(), rectangle.getHeight());
    }

    protected int getPageRotation() {
        return this.reader.getPageRotation(this.parameters.getFieldParameters().getPage());
    }

    protected AnnotationBox toAnnotationBox(SignatureFieldDimensionAndPosition dimensionAndPosition) {
        AnnotationBox annotationBox = dimensionAndPosition.getAnnotationBox();
        return annotationBox.toPdfPageCoordinates(this.getPageAnnotationBox().getHeight());
    }

    private AnnotationBox getSignatureFieldAnnotationBox() {
        PdfArray rectArray;
        PdfDictionary widget;
        AcroFields.Item signatureField = this.getExistingSignatureFieldToFill();
        if (signatureField != null && (widget = signatureField.getWidget(0)) != null && (rectArray = widget.getAsArray(PdfName.RECT)) != null && rectArray.size() == 4) {
            return new AnnotationBox(rectArray.getAsNumber(0).floatValue(), rectArray.getAsNumber(1).floatValue(), rectArray.getAsNumber(2).floatValue(), rectArray.getAsNumber(3).floatValue());
        }
        return null;
    }

    private AcroFields.Item getExistingSignatureFieldToFill() {
        AcroFields acroFields;
        List signatureNames;
        String signatureFieldId = this.parameters.getFieldParameters().getFieldId();
        if (Utils.isStringNotEmpty((String)signatureFieldId) && (signatureNames = (acroFields = this.reader.getAcroFields()).getFieldNamesWithBlankSignatures()).contains(signatureFieldId)) {
            return acroFields.getFieldItem(signatureFieldId);
        }
        return null;
    }

    protected void checkColorSpace(PdfReader reader) {
        if (!this.parameters.isEmpty()) {
            PdfDictionary catalog = reader.getCatalog();
            List<List<String>> profiles = this.getOutputIntents(catalog);
            PdfName colorSpaceName = this.getExpectedColorSpaceName();
            if (Utils.isCollectionEmpty(profiles)) {
                this.addColorSpace(catalog, colorSpaceName);
            } else if (profiles.size() > 1) {
                LOG.warn("PDF contains multiple color spaces. Be aware: not compatible with PDF/A.");
            } else if (PdfName.DEVICECMYK.equals((Object)colorSpaceName) && !this.isProfilePresent(profiles, "cmyk")) {
                LOG.warn("PDF does not contain a CMYK profile! Be aware: not compatible with PDF/A.");
            } else if (PdfName.DEVICERGB.equals((Object)colorSpaceName) && !this.isProfilePresent(profiles, "rgb")) {
                LOG.warn("PDF does not contain an RGB profile! Be aware: not compatible with PDF/A.");
            }
        }
    }

    private List<List<String>> getOutputIntents(PdfDictionary catalog) {
        ArrayList<List<String>> profiles = new ArrayList<List<String>>();
        PdfArray outputIntentsArray = catalog.getAsArray(PdfName.OUTPUTINTENTS);
        if (outputIntentsArray != null) {
            for (int i = 0; i < outputIntentsArray.size(); ++i) {
                PdfDictionary dict = outputIntentsArray.getAsDict(i);
                if (dict == null) continue;
                ArrayList<String> outputIntents = new ArrayList<String>();
                PdfString str = dict.getAsString(PdfName.INFO);
                if (str != null) {
                    outputIntents.add(str.toString());
                }
                if ((str = dict.getAsString(PdfName.OUTPUTCONDITION)) != null) {
                    outputIntents.add(str.toString());
                }
                if ((str = dict.getAsString(PdfName.OUTPUTCONDITIONIDENTIFIER)) != null) {
                    outputIntents.add(str.toString());
                }
                profiles.add(outputIntents);
            }
        }
        return profiles;
    }

    protected abstract PdfName getExpectedColorSpaceName();

    protected void addColorSpace(PdfDictionary catalog, PdfName colorSpaceName) {
        if (PdfName.DEVICERGB.equals((Object)colorSpaceName) || PdfName.DEVICEGRAY.equals((Object)colorSpaceName)) {
            try {
                String outputCondition = "sRGB";
                ICC_Profile iccProfile = ICC_Profile.getInstance(1000);
                PdfWriter writer = this.appearance.getStamper().getWriter();
                writer.setOutputIntents(outputCondition, outputCondition, null, null, iccProfile);
                PdfDictionary extraCatalog = writer.getExtraCatalog();
                PdfArray outputIntents = extraCatalog.getAsArray(PdfName.OUTPUTINTENTS);
                outputIntents.getAsDict(0).put(PdfName.S, (PdfObject)PdfName.GTS_PDFA1);
                catalog.mergeDifferent(extraCatalog);
                LOG.info("No color profile is present in the provided document. A new color profile '{}' has been added.", (Object)outputCondition);
            }
            catch (IOException e) {
                LOG.warn("Unable to add a new color profile to PDF document : {}", (Object)e.getMessage(), (Object)e);
            }
        } else {
            LOG.warn("Color space '{}' is not supported. Be aware: the produced PDF may be not compatible with PDF/A.", (Object)colorSpaceName);
        }
    }

    private boolean isProfilePresent(List<List<String>> profiles, String profileName) {
        for (List<String> profile : profiles) {
            for (String outputIntent : profile) {
                if (!Utils.isStringNotEmpty((String)outputIntent) || !outputIntent.toLowerCase().contains(profileName)) continue;
                return true;
            }
        }
        return false;
    }

    protected AnnotationBox getRotatedAnnotationRelativelyPageRotation(AnnotationBox annotationBox) {
        AnnotationBox pageAnnotationBox = this.getPageAnnotationBox();
        int pageRotation = this.getPageRotation();
        return ImageRotationUtils.rotateRelativelyWrappingBox((AnnotationBox)annotationBox, (AnnotationBox)pageAnnotationBox, (int)pageRotation);
    }

    protected Rectangle toITextRectangle(AnnotationBox annotationBox) {
        return new Rectangle(annotationBox.getMinX(), annotationBox.getMinY(), annotationBox.getMaxX(), annotationBox.getMaxY());
    }

    protected int getFinalRotation(int globalRotation, int pageRotation) {
        int finalRotation = globalRotation + pageRotation;
        if (finalRotation > 360) {
            finalRotation -= 360;
        } else if (finalRotation < 0) {
            finalRotation = 360 - finalRotation;
        }
        return finalRotation;
    }
}

