/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.openpdf;

import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import eu.europa.esig.dss.pdf.PdfArray;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.PdfObject;
import eu.europa.esig.dss.pdf.PdfSimpleObject;
import eu.europa.esig.dss.pdf.openpdf.ITextObjectKey;
import eu.europa.esig.dss.pdf.openpdf.ITextPdfArray;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ITextPdfDict
implements PdfDict {
    private static final Logger LOG = LoggerFactory.getLogger(ITextPdfDict.class);
    private final PdfDictionary wrapped;
    private final PdfObject parent;

    public ITextPdfDict() {
        this(new PdfDictionary(), null);
    }

    public ITextPdfDict(PdfDictionary wrapped) {
        this(wrapped, null);
    }

    public ITextPdfDict(PdfDictionary wrapped, PdfObject parent) {
        Objects.requireNonNull(wrapped, "Pdf dictionary shall be provided!");
        this.wrapped = wrapped;
        this.parent = parent;
    }

    public PdfDictionary getValue() {
        return this.wrapped;
    }

    public PdfObject getParent() {
        return this.parent;
    }

    public PdfDict getAsDict(String name) {
        com.lowagie.text.pdf.PdfObject directObject = this.wrapped.getDirectObject(new PdfName(name));
        if (directObject instanceof PdfDictionary) {
            return new ITextPdfDict((PdfDictionary)directObject, (PdfObject)this);
        }
        return null;
    }

    public PdfArray getAsArray(String name) {
        com.lowagie.text.pdf.PdfArray asArray = this.wrapped.getAsArray(new PdfName(name));
        if (asArray == null) {
            return null;
        }
        return new ITextPdfArray(asArray, (PdfObject)this);
    }

    public byte[] getBinariesValue(String name) {
        com.lowagie.text.pdf.PdfObject val = this.wrapped.get(new PdfName(name));
        if (val == null) {
            return null;
        }
        if (val instanceof PdfString) {
            PdfString pdfString = (PdfString)val;
            return pdfString.getOriginalBytes();
        }
        return val.getBytes();
    }

    public String[] list() {
        Set keyPdfNames = this.wrapped.getKeys();
        String[] keys = new String[keyPdfNames.size()];
        PdfName[] array = keyPdfNames.toArray(new PdfName[keyPdfNames.size()]);
        for (int i = 0; i < array.length; ++i) {
            keys[i] = PdfName.decodeName((String)array[i].toString());
        }
        return keys;
    }

    public String getStringValue(String key) {
        PdfString pdfString = this.wrapped.getAsString(new PdfName(key));
        if (pdfString == null) {
            return null;
        }
        return pdfString.toUnicodeString();
    }

    public String getNameValue(String key) {
        PdfName pdfName = this.wrapped.getAsName(new PdfName(key));
        if (pdfName == null) {
            return null;
        }
        return PdfName.decodeName((String)pdfName.toString());
    }

    public Date getDateValue(String name) {
        com.lowagie.text.pdf.PdfObject pdfObject = this.wrapped.get(new PdfName(name));
        PdfString s = (PdfString)pdfObject;
        if (s == null) {
            return null;
        }
        return PdfDate.decode((String)s.toString()).getTime();
    }

    public Number getNumberValue(String name) {
        PdfNumber pdfNumber = this.wrapped.getAsNumber(new PdfName(name));
        if (pdfNumber != null) {
            return pdfNumber.doubleValue();
        }
        return null;
    }

    public PdfObject getObject(String name) {
        com.lowagie.text.pdf.PdfObject pdfObject = this.wrapped.getDirectObject(new PdfName(name));
        if (pdfObject == null) {
            return null;
        }
        if (pdfObject instanceof PdfDictionary) {
            return this.getAsDict(name);
        }
        if (pdfObject instanceof com.lowagie.text.pdf.PdfArray) {
            return this.getAsArray(name);
        }
        if (pdfObject instanceof PdfString) {
            return new PdfSimpleObject((Object)this.getStringValue(name), (PdfObject)this);
        }
        if (pdfObject instanceof PdfName) {
            return new PdfSimpleObject((Object)this.getNameValue(name), (PdfObject)this);
        }
        if (pdfObject instanceof PdfNumber) {
            return new PdfSimpleObject((Object)this.getNumberValue(name), (PdfObject)this);
        }
        if (pdfObject instanceof PdfBoolean) {
            return new PdfSimpleObject((Object)((PdfBoolean)pdfObject).booleanValue(), (PdfObject)this);
        }
        if (pdfObject instanceof PdfNull) {
            return null;
        }
        LOG.warn("Unable to process an entry with name '{}' of type '{}'.", (Object)name, pdfObject.getClass());
        return null;
    }

    @Deprecated
    public Long getObjectNumber(String name) {
        ITextObjectKey objectKey = this.getObjectKey(name);
        if (objectKey != null) {
            return objectKey.getNumber();
        }
        return null;
    }

    public ITextObjectKey getObjectKey(String name) {
        PdfIndirectReference indirectObject = this.wrapped.getAsIndirectObject(new PdfName(name));
        if (indirectObject != null) {
            return new ITextObjectKey(indirectObject);
        }
        return null;
    }

    public byte[] getStreamBytes() throws IOException {
        if (this.wrapped instanceof PRStream) {
            return PdfReader.getStreamBytes((PRStream)((PRStream)this.wrapped));
        }
        return null;
    }

    public InputStream createRawInputStream() throws IOException {
        if (this.wrapped instanceof PRStream) {
            byte[] streamBytesRaw = PdfReader.getStreamBytesRaw((PRStream)((PRStream)this.wrapped));
            return new ByteArrayInputStream(streamBytesRaw);
        }
        return null;
    }

    public long getRawStreamSize() throws IOException {
        if (this.wrapped instanceof PRStream) {
            byte[] streamBytesRaw = PdfReader.getStreamBytesRaw((PRStream)((PRStream)this.wrapped));
            return streamBytesRaw.length;
        }
        return -1L;
    }

    public void setPdfObjectValue(String key, PdfObject pdfObject) {
        Object value = pdfObject.getValue();
        if (!(value instanceof com.lowagie.text.pdf.PdfObject)) {
            throw new UnsupportedOperationException("pdfObject argument shall be of PdfObject type!");
        }
        this.wrapped.put(new PdfName(key), (com.lowagie.text.pdf.PdfObject)value);
    }

    public void setNameValue(String key, String value) {
        this.wrapped.put(new PdfName(key), (com.lowagie.text.pdf.PdfObject)new PdfName(value));
    }

    public void setStringValue(String key, String value) {
        this.wrapped.put(new PdfName(key), (com.lowagie.text.pdf.PdfObject)new PdfString(value));
    }

    public void setIntegerValue(String key, Integer value) {
        this.wrapped.put(new PdfName(key), (com.lowagie.text.pdf.PdfObject)new PdfNumber(value.intValue()));
    }

    public void setDirect(boolean direct) {
    }

    public boolean match(PdfDict pdfDict) {
        if (!(pdfDict instanceof ITextPdfDict)) {
            throw new UnsupportedOperationException("pdfDict argument shall be of ITextPdfDict type!");
        }
        ITextPdfDict iTextPdfDict = (ITextPdfDict)pdfDict;
        for (PdfName key : iTextPdfDict.wrapped.getKeys()) {
            com.lowagie.text.pdf.PdfObject targetObject = iTextPdfDict.wrapped.get(key);
            com.lowagie.text.pdf.PdfObject currentObject = this.wrapped.get(key);
            if (targetObject == null || targetObject.equals(currentObject)) continue;
            return false;
        }
        return true;
    }
}

