/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.openpdf;

import com.lowagie.text.exceptions.BadPasswordException;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfSignatureAppearance;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import eu.europa.esig.dss.enumerations.CertificationPermission;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.pades.PAdESCommonParameters;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.SignatureFieldParameters;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pades.exception.InvalidPasswordException;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.PdfObjectKey;
import eu.europa.esig.dss.pades.validation.PdfValidationDataContainer;
import eu.europa.esig.dss.pdf.AbstractPDFSignatureService;
import eu.europa.esig.dss.pdf.AnnotationBox;
import eu.europa.esig.dss.pdf.PDFServiceMode;
import eu.europa.esig.dss.pdf.PdfDocumentReader;
import eu.europa.esig.dss.pdf.modifications.PdfModification;
import eu.europa.esig.dss.pdf.openpdf.ITextDocumentReader;
import eu.europa.esig.dss.pdf.openpdf.visible.ITextSignatureDrawer;
import eu.europa.esig.dss.pdf.openpdf.visible.ITextSignatureDrawerFactory;
import eu.europa.esig.dss.pdf.visible.ImageRotationUtils;
import eu.europa.esig.dss.pdf.visible.SignatureDrawer;
import eu.europa.esig.dss.pdf.visible.SignatureDrawerFactory;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.ValidationData;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITextPDFSignatureService
extends AbstractPDFSignatureService {
    private static final Logger LOG = LoggerFactory.getLogger(ITextPDFSignatureService.class);

    public ITextPDFSignatureService(PDFServiceMode serviceMode, ITextSignatureDrawerFactory signatureDrawerFactory) {
        super(serviceMode, (SignatureDrawerFactory)signatureDrawerFactory);
    }

    private PdfStamper prepareStamper(ITextDocumentReader documentReader, OutputStream output, PAdESCommonParameters parameters) throws IOException {
        PdfReader reader = documentReader.getPdfReader();
        PdfStamper stp = PdfStamper.createSignature((PdfReader)reader, (OutputStream)output, (char)'\u0000', null, (boolean)true);
        stp.setIncludeFileID(true);
        stp.setOverrideFileId(documentReader.generateDocumentId(parameters));
        stp.setUpdateDocInfo(false);
        stp.setUpdateMetadata(false);
        Calendar cal = Calendar.getInstance();
        cal.setTime(parameters.getSigningDate());
        stp.setEnforcedModificationDate(cal);
        PdfSignatureAppearance sap = stp.getSignatureAppearance();
        sap.setAcro6Layers(true);
        SignatureImageParameters imageParameters = parameters.getImageParameters();
        SignatureFieldParameters fieldParameters = imageParameters.getFieldParameters();
        AcroFields.Item fieldItem = this.findExistingSignatureField(reader, fieldParameters);
        if (!imageParameters.isEmpty()) {
            ITextSignatureDrawer signatureDrawer = (ITextSignatureDrawer)this.loadSignatureDrawer(imageParameters);
            signatureDrawer.init(imageParameters, reader, sap);
            if (fieldItem == null) {
                this.getVisibleSignatureFieldBoxPosition(signatureDrawer, documentReader, fieldParameters);
            }
            signatureDrawer.draw();
        }
        PdfDictionary signatureDictionary = this.createSignatureDictionary(reader, fieldItem, parameters);
        if ("Sig".equals(this.getType())) {
            PAdESSignatureParameters signatureParameters = (PAdESSignatureParameters)parameters;
            CertificationPermission permission = signatureParameters.getPermission();
            if (permission != null && !this.containsFilledSignature(reader)) {
                sap.setCertificationLevel(permission.getCode());
            }
            cal.setTimeZone(signatureParameters.getSigningTimeZone());
            sap.setSignDate(cal);
        }
        sap.setCryptoDictionary(signatureDictionary);
        int csize = parameters.getContentSize();
        HashMap<PdfName, Integer> exc = new HashMap<PdfName, Integer>();
        exc.put(PdfName.CONTENTS, csize * 2 + 2);
        this.digitalSignatureEnhancement(documentReader, parameters);
        sap.preClose(exc);
        return stp;
    }

    private AcroFields.Item findExistingSignatureField(PdfReader reader, SignatureFieldParameters fieldParameters) {
        String signatureFieldId = fieldParameters.getFieldId();
        if (Utils.isStringNotEmpty((String)signatureFieldId)) {
            AcroFields acroFields = reader.getAcroFields();
            List signatureNames = acroFields.getFieldNamesWithBlankSignatures();
            if (signatureNames.contains(signatureFieldId)) {
                return acroFields.getFieldItem(signatureFieldId);
            }
            throw new IllegalArgumentException(String.format("The signature field with id '%s' does not exist.", signatureFieldId));
        }
        return null;
    }

    private PdfDictionary createSignatureDictionary(PdfReader reader, AcroFields.Item fieldItem, PAdESCommonParameters parameters) {
        PdfDictionary dic;
        if (fieldItem != null) {
            dic = fieldItem.getMerged(0);
            this.setFieldMDP(reader, dic);
        } else {
            dic = new PdfDictionary();
        }
        PdfName type = new PdfName(this.getType());
        dic.put(PdfName.TYPE, (PdfObject)type);
        if (Utils.isStringNotEmpty((String)parameters.getFilter())) {
            dic.put(PdfName.FILTER, (PdfObject)new PdfName(parameters.getFilter()));
        }
        if (Utils.isStringNotEmpty((String)parameters.getSubFilter())) {
            dic.put(PdfName.SUBFILTER, (PdfObject)new PdfName(parameters.getSubFilter()));
        }
        if (Utils.isStringNotEmpty((String)parameters.getAppName())) {
            PdfDictionary propBuildDict = new PdfDictionary();
            dic.put(new PdfName("Prop_Build"), (PdfObject)propBuildDict);
            PdfDictionary appDict = new PdfDictionary();
            propBuildDict.put(new PdfName("App"), (PdfObject)appDict);
            appDict.put(PdfName.NAME, (PdfObject)new PdfName(parameters.getAppName()));
        }
        if (PdfName.SIG.equals((Object)type)) {
            PAdESSignatureParameters signatureParameters = (PAdESSignatureParameters)parameters;
            if (Utils.isStringNotEmpty((String)signatureParameters.getSignerName())) {
                dic.put(PdfName.NAME, (PdfObject)new PdfString(signatureParameters.getSignerName(), "UnicodeBig"));
            }
            if (Utils.isStringNotEmpty((String)signatureParameters.getReason())) {
                dic.put(PdfName.REASON, (PdfObject)new PdfString(signatureParameters.getReason(), "UnicodeBig"));
            }
            if (Utils.isStringNotEmpty((String)signatureParameters.getLocation())) {
                dic.put(PdfName.LOCATION, (PdfObject)new PdfString(signatureParameters.getLocation(), "UnicodeBig"));
            }
            if (Utils.isStringNotEmpty((String)signatureParameters.getContactInfo())) {
                dic.put(PdfName.CONTACTINFO, (PdfObject)new PdfString(signatureParameters.getContactInfo(), "UnicodeBig"));
            }
        }
        return dic;
    }

    private void setFieldMDP(PdfReader reader, PdfDictionary sigFieldDictionary) {
        PdfDictionary lockDict = sigFieldDictionary.getAsDict(PdfName.LOCK);
        if (lockDict != null) {
            PdfDictionary transformParams = new PdfDictionary();
            transformParams.putAll(lockDict);
            transformParams.put(PdfName.TYPE, (PdfObject)PdfName.TRANSFORMPARAMS);
            transformParams.put(PdfName.V, (PdfObject)new PdfName("1.2"));
            PdfDictionary sigRef = new PdfDictionary();
            sigRef.put(PdfName.TYPE, (PdfObject)PdfName.SIGREF);
            sigRef.put(PdfName.TRANSFORMMETHOD, (PdfObject)PdfName.FIELDMDP);
            sigRef.put(PdfName.TRANSFORMPARAMS, (PdfObject)transformParams);
            sigRef.put(PdfName.DATA, (PdfObject)reader.getCatalog());
            PdfArray referenceArray = new PdfArray();
            referenceArray.add((PdfObject)sigRef);
            sigFieldDictionary.put(PdfName.REFERENCE, (PdfObject)referenceArray);
        }
    }

    private boolean containsFilledSignature(PdfReader reader) {
        AcroFields acroFields = reader.getAcroFields();
        List signatureNames = acroFields.getSignedFieldNames();
        for (String name : signatureNames) {
            PdfDictionary signatureDictionary = acroFields.getSignatureDictionary(name);
            if (!signatureDictionary.contains(new PdfName("Contents"))) continue;
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    protected DSSMessageDigest computeDigest(DSSDocument toSignDocument, PAdESCommonParameters parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected DSSDocument signDocument(DSSDocument toSignDocument, byte[] cmsSignedData, PAdESCommonParameters parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public DSSDocument addDssDictionary(DSSDocument document, PdfValidationDataContainer validationDataForInclusion, char[] pwd, boolean includeVRIDict) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PdfDictionary buildDSSDictionary(ITextDocumentReader documentReader, PdfWriter writer, PdfValidationDataContainer validationDataForInclusion, boolean includeVRIDict) throws IOException {
        Collection detachedTimestamps;
        PdfDictionary dss = new PdfDictionary();
        PdfArray ocsps = new PdfArray();
        PdfArray crls = new PdfArray();
        PdfArray certs = new PdfArray();
        HashMap<String, PdfObject> knownObjects = new HashMap<String, PdfObject>();
        Collection signatures = validationDataForInclusion.getSignatures();
        if (Utils.isCollectionNotEmpty((Collection)signatures)) {
            PdfDictionary vrim = new PdfDictionary();
            for (AdvancedSignature signature : signatures) {
                Set ocspTokensToAdd;
                Set crlTokensToAdd;
                ValidationData validationDataToAdd = new ValidationData();
                ValidationData signatureValidationData = validationDataForInclusion.getAllValidationDataForSignature(signature);
                validationDataToAdd.addValidationData(signatureValidationData);
                if (validationDataToAdd.isEmpty()) continue;
                PdfDictionary vri = new PdfDictionary();
                Set certificateTokensToAdd = validationDataToAdd.getCertificateTokens();
                if (Utils.isCollectionNotEmpty((Collection)certificateTokensToAdd)) {
                    PdfArray sigCerts = new PdfArray();
                    for (CertificateToken certToken : certificateTokensToAdd) {
                        PdfObject iref = this.getPdfObjectForToken(documentReader, writer, validationDataForInclusion, knownObjects, (Token)certToken);
                        if (sigCerts.contains(iref)) continue;
                        sigCerts.add(iref);
                        if (certs.contains(iref)) continue;
                        certs.add(iref);
                    }
                    vri.put(new PdfName("Cert"), (PdfObject)sigCerts);
                }
                if (Utils.isCollectionNotEmpty((Collection)(crlTokensToAdd = validationDataToAdd.getCrlTokens()))) {
                    CertificateToken certToken;
                    PdfArray sigCrls = new PdfArray();
                    certToken = crlTokensToAdd.iterator();
                    while (certToken.hasNext()) {
                        CRLToken crlToken = (CRLToken)certToken.next();
                        PdfObject iref = this.getPdfObjectForToken(documentReader, writer, validationDataForInclusion, knownObjects, (Token)crlToken);
                        if (sigCrls.contains(iref)) continue;
                        sigCrls.add(iref);
                        if (crls.contains(iref)) continue;
                        crls.add(iref);
                    }
                    vri.put(new PdfName("CRL"), (PdfObject)sigCrls);
                }
                if (Utils.isCollectionNotEmpty((Collection)(ocspTokensToAdd = validationDataToAdd.getOcspTokens()))) {
                    PdfArray sigOcsps = new PdfArray();
                    for (OCSPToken ocspToken : validationDataToAdd.getOcspTokens()) {
                        PdfObject iref = this.getPdfObjectForToken(documentReader, writer, validationDataForInclusion, knownObjects, (Token)ocspToken);
                        if (sigOcsps.contains(iref)) continue;
                        sigOcsps.add(iref);
                        if (ocsps.contains(iref)) continue;
                        ocsps.add(iref);
                    }
                    vri.put(new PdfName("OCSP"), (PdfObject)sigOcsps);
                }
                String vriKey = ((PAdESSignature)signature).getVRIKey();
                vrim.put(new PdfName(vriKey), (PdfObject)vri);
            }
            if (includeVRIDict) {
                dss.put(new PdfName("VRI"), (PdfObject)writer.addToBody((PdfObject)vrim, false).getIndirectReference());
            }
        }
        if (Utils.isCollectionNotEmpty((Collection)(detachedTimestamps = validationDataForInclusion.getDetachedTimestamps()))) {
            Set ocspTokensToAdd;
            Set crlTokensToAdd;
            ValidationData validationDataToAdd = validationDataForInclusion.getAllValidationData();
            Set certificateTokensToAdd = validationDataToAdd.getCertificateTokens();
            if (Utils.isCollectionNotEmpty((Collection)certificateTokensToAdd)) {
                for (CertificateToken certToken : certificateTokensToAdd) {
                    PdfObject iref = this.getPdfObjectForToken(documentReader, writer, validationDataForInclusion, knownObjects, (Token)certToken);
                    if (certs.contains(iref)) continue;
                    certs.add(iref);
                }
            }
            if (Utils.isCollectionNotEmpty((Collection)(crlTokensToAdd = validationDataToAdd.getCrlTokens()))) {
                for (CRLToken crlToken : crlTokensToAdd) {
                    PdfObject iref = this.getPdfObjectForToken(documentReader, writer, validationDataForInclusion, knownObjects, (Token)crlToken);
                    if (crls.contains(iref)) continue;
                    crls.add(iref);
                }
            }
            if (Utils.isCollectionNotEmpty((Collection)(ocspTokensToAdd = validationDataToAdd.getOcspTokens()))) {
                for (OCSPToken ocspToken : validationDataToAdd.getOcspTokens()) {
                    PdfObject iref = this.getPdfObjectForToken(documentReader, writer, validationDataForInclusion, knownObjects, (Token)ocspToken);
                    if (ocsps.contains(iref)) continue;
                    ocsps.add(iref);
                }
            }
        }
        if (!ocsps.isEmpty()) {
            dss.put(new PdfName("OCSPs"), (PdfObject)ocsps);
        }
        if (!crls.isEmpty()) {
            dss.put(new PdfName("CRLs"), (PdfObject)crls);
        }
        if (!certs.isEmpty()) {
            dss.put(new PdfName("Certs"), (PdfObject)certs);
        }
        return dss;
    }

    private PdfObject getPdfObjectForToken(ITextDocumentReader documentReader, PdfWriter writer, PdfValidationDataContainer validationDataContainer, Map<String, PdfObject> knownObjects, Token token) throws IOException {
        String tokenKey = validationDataContainer.getTokenKey(token);
        PdfObject object = knownObjects.get(tokenKey);
        if (object != null) {
            return object;
        }
        PdfObjectKey objectKey = validationDataContainer.getTokenReference(token);
        if (objectKey == null) {
            PdfStream ps = documentReader.createPdfStream(token.getEncoded());
            object = writer.addToBody((PdfObject)ps, false).getIndirectReference();
        } else {
            object = new PRIndirectReference(documentReader.getPdfReader(), (int)objectKey.getNumber(), objectKey.getGeneration());
        }
        knownObjects.put(tokenKey, object);
        return object;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<String> getAvailableSignatureFields(DSSDocument document, char[] pwd) {
        try (InputStream is = document.openStream();){
            List list;
            try (PdfReader reader = new PdfReader(is, this.getPasswordBytes(pwd));){
                AcroFields acroFields = reader.getAcroFields();
                list = acroFields.getFieldNamesWithBlankSignatures();
            }
            return list;
        }
        catch (BadPasswordException e) {
            throw new InvalidPasswordException(e.getMessage());
        }
        catch (Exception e) {
            throw new DSSException(String.format("Unable to retrieve available signature fields : %s", e.getMessage()), (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public DSSDocument addNewSignatureField(DSSDocument document, SignatureFieldParameters parameters, char[] pwd) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected AnnotationBox getVisibleSignatureFieldBoxPosition(SignatureDrawer signatureDrawer, PdfDocumentReader documentReader, SignatureFieldParameters parameters) throws IOException {
        AnnotationBox annotationBox = super.getVisibleSignatureFieldBoxPosition(signatureDrawer, documentReader, parameters);
        return this.alignRelativelyPageBox(documentReader, parameters, annotationBox);
    }

    protected AnnotationBox getVisibleSignatureFieldBoxPosition(PdfDocumentReader reader, SignatureFieldParameters parameters) throws IOException {
        AnnotationBox annotationBox = super.getVisibleSignatureFieldBoxPosition(reader, parameters);
        return this.alignRelativelyPageBox(reader, parameters, annotationBox);
    }

    private AnnotationBox alignRelativelyPageBox(PdfDocumentReader reader, SignatureFieldParameters parameters, AnnotationBox annotationBox) {
        AnnotationBox pageBox = reader.getPageBox(parameters.getPage());
        int pageRotation = reader.getPageRotation(parameters.getPage());
        return ImageRotationUtils.rotateRelativelyWrappingBox((AnnotationBox)annotationBox, (AnnotationBox)pageBox, (int)pageRotation);
    }

    public DSSDocument previewPageWithVisualSignature(DSSDocument toSignDocument, PAdESCommonParameters parameters) {
        throw new UnsupportedOperationException("Screenshot feature is not supported by Open PDF");
    }

    public DSSDocument previewSignatureField(DSSDocument toSignDocument, PAdESCommonParameters parameters) {
        throw new UnsupportedOperationException("Screenshot feature is not supported by Open PDF");
    }

    protected PdfDocumentReader loadPdfDocumentReader(DSSDocument dssDocument, char[] passwordProtection) throws IOException {
        return new ITextDocumentReader(dssDocument, this.getPasswordBytes(passwordProtection), this.pdfMemoryUsageSetting);
    }

    protected List<PdfModification> getVisualDifferences(PdfDocumentReader signedRevisionReader, PdfDocumentReader finalRevisionReader) {
        return Collections.emptyList();
    }

    private byte[] getPasswordBytes(char[] passwordProtection) {
        if (Utils.isArrayNotEmpty((char[])passwordProtection)) {
            ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(CharBuffer.wrap(passwordProtection));
            byte[] bytes = new byte[byteBuffer.limit()];
            byteBuffer.get(bytes);
            return bytes;
        }
        return null;
    }
}

