/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.validation;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.validation.ASiCContainerDiagnosticDataBuilder;
import eu.europa.esig.dss.asic.common.validation.AbstractASiCContainerAnalyzer;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.spi.validation.analyzer.DocumentAnalyzer;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.reports.diagnostic.SignedDocumentDiagnosticDataBuilder;
import java.util.List;

public abstract class AbstractASiCContainerValidator
extends SignedDocumentValidator {
    protected AbstractASiCContainerValidator(AbstractASiCContainerAnalyzer asicContainerAnalyzer) {
        super((DocumentAnalyzer)asicContainerAnalyzer);
    }

    public AbstractASiCContainerAnalyzer getDocumentAnalyzer() {
        return (AbstractASiCContainerAnalyzer)super.getDocumentAnalyzer();
    }

    public boolean isSupported(ASiCContent asicContent) {
        return this.getDocumentAnalyzer().isSupported(asicContent);
    }

    public ASiCContainerType getContainerType() {
        return this.getDocumentAnalyzer().getContainerType();
    }

    public List<DSSDocument> getAllDocuments() {
        return this.getDocumentAnalyzer().getAllDocuments();
    }

    public List<DSSDocument> getSignatureDocuments() {
        return this.getDocumentAnalyzer().getSignatureDocuments();
    }

    public List<DSSDocument> getSignedDocuments() {
        return this.getDocumentAnalyzer().getSignedDocuments();
    }

    public List<DSSDocument> getManifestDocuments() {
        return this.getDocumentAnalyzer().getManifestDocuments();
    }

    public List<DSSDocument> getTimestampDocuments() {
        return this.getDocumentAnalyzer().getTimestampDocuments();
    }

    public List<DSSDocument> getEvidenceRecordDocuments() {
        return this.getDocumentAnalyzer().getEvidenceRecordDocuments();
    }

    public List<DSSDocument> getArchiveManifestDocuments() {
        return this.getDocumentAnalyzer().getArchiveManifestDocuments();
    }

    public List<DSSDocument> getEvidenceRecordManifestDocuments() {
        return this.getDocumentAnalyzer().getEvidenceRecordManifestDocuments();
    }

    public List<DSSDocument> getAllManifestDocuments() {
        return this.getDocumentAnalyzer().getAllManifestDocuments();
    }

    public List<DSSDocument> getArchiveDocuments() {
        return this.getDocumentAnalyzer().getArchiveDocuments();
    }

    public DSSDocument getMimeTypeDocument() {
        return this.getDocumentAnalyzer().getMimeTypeDocument();
    }

    public List<DSSDocument> getUnsupportedDocuments() {
        return this.getDocumentAnalyzer().getUnsupportedDocuments();
    }

    public List<ManifestFile> getManifestFiles() {
        return this.getDocumentAnalyzer().getManifestFiles();
    }

    protected SignedDocumentDiagnosticDataBuilder initializeDiagnosticDataBuilder() {
        ASiCContainerDiagnosticDataBuilder builder = this.instantiateASiCDiagnosticDataBuilder();
        builder.containerInfo(this.getDocumentAnalyzer().getContainerInfo());
        return builder;
    }

    protected ASiCContainerDiagnosticDataBuilder instantiateASiCDiagnosticDataBuilder() {
        return new ASiCContainerDiagnosticDataBuilder();
    }
}

