/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.evidencerecord;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ASiCContentDocumentFilter {
    private boolean mimetypeDocument;
    private boolean signedDocuments;
    private boolean signatureDocuments;
    private boolean timestampDocuments;
    private boolean evidenceRecordDocuments;
    private boolean manifestDocuments;
    private boolean archiveManifestDocuments;
    private boolean evidenceRecordManifestDocuments;
    private boolean unsupportedDocuments;
    private Collection<String> excludedFilenames;

    public void setMimetypeDocument(boolean mimetypeDocument) {
        this.mimetypeDocument = mimetypeDocument;
    }

    public void setSignedDocuments(boolean signedDocuments) {
        this.signedDocuments = signedDocuments;
    }

    public void setSignatureDocuments(boolean signatureDocuments) {
        this.signatureDocuments = signatureDocuments;
    }

    public void setTimestampDocuments(boolean timestampDocuments) {
        this.timestampDocuments = timestampDocuments;
    }

    public void setEvidenceRecordDocuments(boolean evidenceRecordDocuments) {
        this.evidenceRecordDocuments = evidenceRecordDocuments;
    }

    public void setManifestDocuments(boolean manifestDocuments) {
        this.manifestDocuments = manifestDocuments;
    }

    public void setArchiveManifestDocuments(boolean archiveManifestDocuments) {
        this.archiveManifestDocuments = archiveManifestDocuments;
    }

    public void setEvidenceRecordManifestDocuments(boolean evidenceRecordManifestDocuments) {
        this.evidenceRecordManifestDocuments = evidenceRecordManifestDocuments;
    }

    public void setUnsupportedDocuments(boolean unsupportedDocuments) {
        this.unsupportedDocuments = unsupportedDocuments;
    }

    public void setExcludedFilenames(Collection<String> excludedFilenames) {
        this.excludedFilenames = excludedFilenames;
    }

    public List<DSSDocument> filter(ASiCContent asicContent) {
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        if (this.mimetypeDocument && asicContent.getMimeTypeDocument() != null) {
            DSSDocument mimeTypeDocument = asicContent.getMimeTypeDocument();
            if (Utils.isCollectionEmpty(this.excludedFilenames) || !this.excludedFilenames.contains(mimeTypeDocument.getName())) {
                result.add(mimeTypeDocument);
            }
        }
        if (this.signedDocuments) {
            result.addAll(this.filterDocuments(asicContent.getSignedDocuments()));
        }
        if (this.signatureDocuments) {
            result.addAll(this.filterDocuments(asicContent.getSignatureDocuments()));
        }
        if (this.timestampDocuments) {
            result.addAll(this.filterDocuments(asicContent.getTimestampDocuments()));
        }
        if (this.evidenceRecordDocuments) {
            result.addAll(this.filterDocuments(asicContent.getEvidenceRecordDocuments()));
        }
        if (this.manifestDocuments) {
            result.addAll(this.filterDocuments(asicContent.getManifestDocuments()));
        }
        if (this.archiveManifestDocuments) {
            result.addAll(this.filterDocuments(asicContent.getArchiveManifestDocuments()));
        }
        if (this.evidenceRecordManifestDocuments) {
            result.addAll(this.filterDocuments(asicContent.getEvidenceRecordManifestDocuments()));
        }
        if (this.unsupportedDocuments) {
            result.addAll(this.filterDocuments(asicContent.getUnsupportedDocuments()));
        }
        return result;
    }

    private Collection<DSSDocument> filterDocuments(Collection<DSSDocument> documents) {
        if (Utils.isCollectionEmpty(this.excludedFilenames)) {
            return documents;
        }
        return documents.stream().filter((? super T d) -> !this.excludedFilenames.contains(d.getName())).collect(Collectors.toList());
    }
}

