/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common;

import eu.europa.esig.dss.asic.common.SecureContainerHandler;
import eu.europa.esig.dss.asic.common.ZipContainerHandlerBuilder;
import eu.europa.esig.dss.signature.resources.DSSResourcesHandlerBuilder;
import eu.europa.esig.dss.signature.resources.InMemoryResourcesHandlerBuilder;
import java.util.Objects;

public class SecureContainerHandlerBuilder
implements ZipContainerHandlerBuilder<SecureContainerHandler> {
    private long threshold = 1000000L;
    private long maxCompressionRatio = 100L;
    private int maxAllowedFilesAmount = 1000;
    private int maxMalformedFiles = 100;
    private boolean extractComments = false;
    private DSSResourcesHandlerBuilder resourcesHandlerBuilder = new InMemoryResourcesHandlerBuilder();

    public SecureContainerHandlerBuilder setThreshold(long threshold) {
        this.threshold = threshold;
        return this;
    }

    public SecureContainerHandlerBuilder setMaxCompressionRatio(long maxCompressionRatio) {
        this.maxCompressionRatio = maxCompressionRatio;
        return this;
    }

    public SecureContainerHandlerBuilder setMaxAllowedFilesAmount(int maxAllowedFilesAmount) {
        this.maxAllowedFilesAmount = maxAllowedFilesAmount;
        return this;
    }

    public SecureContainerHandlerBuilder setMaxMalformedFiles(int maxMalformedFiles) {
        this.maxMalformedFiles = maxMalformedFiles;
        return this;
    }

    public SecureContainerHandlerBuilder setExtractComments(boolean extractComments) {
        this.extractComments = extractComments;
        return this;
    }

    public SecureContainerHandlerBuilder setResourcesHandlerBuilder(DSSResourcesHandlerBuilder resourcesHandlerBuilder) {
        Objects.requireNonNull(resourcesHandlerBuilder, "DSSResourcesHandlerBuilder cannot be null!");
        this.resourcesHandlerBuilder = resourcesHandlerBuilder;
        return this;
    }

    @Override
    public SecureContainerHandler build() {
        SecureContainerHandler secureContainerHandler = new SecureContainerHandler();
        secureContainerHandler.setThreshold(this.threshold);
        secureContainerHandler.setMaxCompressionRatio(this.maxCompressionRatio);
        secureContainerHandler.setMaxAllowedFilesAmount(this.maxAllowedFilesAmount);
        secureContainerHandler.setMaxMalformedFiles(this.maxMalformedFiles);
        secureContainerHandler.setExtractComments(this.extractComments);
        secureContainerHandler.setResourcesHandlerBuilder(this.resourcesHandlerBuilder);
        return secureContainerHandler;
    }
}

