/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common;

import java.io.Serializable;
import java.nio.file.attribute.FileTime;
import java.util.Date;
import java.util.Objects;
import java.util.zip.ZipEntry;

public class DSSZipEntry
implements Serializable {
    private static final long serialVersionUID = -6639922911484163896L;
    private String name;
    private String comment;
    private int compressionMethod = 8;
    private FileTime creationTime;
    private byte[] extra;
    private FileTime modificationTime;
    private FileTime lastAccessTime;
    private long size;
    private long compressedSize;
    private long crc;

    public DSSZipEntry(String name) {
        Objects.requireNonNull(name, "Name cannot be null!");
        this.name = name;
    }

    public DSSZipEntry(ZipEntry zipEntry) {
        Objects.requireNonNull(zipEntry, "ZipEntry cannot be null!");
        this.name = zipEntry.getName();
        if (zipEntry.getComment() != null) {
            this.comment = zipEntry.getComment();
        }
        if (zipEntry.getMethod() != -1) {
            this.compressionMethod = zipEntry.getMethod();
        }
        if (zipEntry.getCreationTime() != null) {
            this.creationTime = zipEntry.getCreationTime();
        }
        if (zipEntry.getExtra() != null) {
            this.extra = zipEntry.getExtra();
        }
        if (zipEntry.getLastModifiedTime() != null) {
            this.modificationTime = zipEntry.getLastModifiedTime();
        }
        if (zipEntry.getLastAccessTime() != null) {
            this.lastAccessTime = zipEntry.getLastAccessTime();
        }
        if (zipEntry.getSize() != -1L) {
            this.size = zipEntry.getSize();
        }
        if (zipEntry.getCompressedSize() != -1L) {
            this.compressedSize = zipEntry.getCompressedSize();
        }
        if (zipEntry.getCrc() != -1L) {
            this.crc = zipEntry.getCrc();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public int getCompressionMethod() {
        return this.compressionMethod;
    }

    public void setCompressionMethod(int compressionMethod) {
        this.compressionMethod = compressionMethod;
    }

    public FileTime getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(FileTime creationTime) {
        this.creationTime = creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime != null ? this.toFileTime(creationTime) : null;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public void setExtra(byte[] extra) {
        this.extra = extra;
    }

    public Date getModificationTime() {
        return this.modificationTime != null ? this.toDate(this.modificationTime) : null;
    }

    public Date getLastAccessTime() {
        return this.lastAccessTime != null ? this.toDate(this.lastAccessTime) : null;
    }

    public long getSize() {
        return this.size;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public long getCrc() {
        return this.crc;
    }

    public ZipEntry createZipEntry() {
        ZipEntry zipEntry = new ZipEntry(this.name);
        if (this.comment != null) {
            zipEntry.setComment(this.comment);
        }
        if (this.compressionMethod != -1) {
            zipEntry.setMethod(this.compressionMethod);
        }
        if (this.creationTime != null) {
            zipEntry.setCreationTime(this.creationTime);
        }
        if (this.extra != null) {
            zipEntry.setExtra(this.extra);
        }
        return zipEntry;
    }

    private FileTime toFileTime(Date date) {
        return FileTime.fromMillis(date.getTime());
    }

    private Date toDate(FileTime fileTime) {
        return new Date(fileTime.toMillis());
    }
}

