/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.definition.ASiCManifestAttribute;
import eu.europa.esig.dss.asic.common.definition.ASiCManifestElement;
import eu.europa.esig.dss.asic.common.definition.ASiCManifestNamespace;
import eu.europa.esig.dss.asic.common.evidencerecord.ASiCContentDocumentFilter;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xml.common.definition.DSSElement;
import eu.europa.esig.dss.xml.common.definition.DSSNamespace;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigAttribute;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigNamespace;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.Objects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class AbstractASiCManifestBuilder {
    protected final ASiCContent asicContent;
    protected final String sigReferenceUri;
    protected final DigestAlgorithm digestAlgorithm;
    private ASiCContentDocumentFilter asicContentDocumentFilter;

    protected AbstractASiCManifestBuilder(ASiCContent asicContent, String sigReferenceUri) {
        this(asicContent, sigReferenceUri, DigestAlgorithm.SHA256);
    }

    protected AbstractASiCManifestBuilder(ASiCContent asicContent, String sigReferenceUri, DigestAlgorithm digestAlgorithm) {
        this.asicContent = asicContent;
        this.sigReferenceUri = sigReferenceUri;
        this.digestAlgorithm = digestAlgorithm;
    }

    public DSSDocument build() {
        Document documentDom = this.buildDom();
        Element asicManifestDom = this.createRootElement(documentDom);
        this.addSigReference(documentDom, asicManifestDom);
        this.addDataObjectReferences(documentDom, asicManifestDom);
        return this.toDSSDocument(documentDom);
    }

    protected Document buildDom() {
        return DomUtils.buildDOM();
    }

    protected Element createRootElement(Document documentDom) {
        Element asicManifestDom = DomUtils.createElementNS((Document)documentDom, (DSSNamespace)ASiCManifestNamespace.NS, (DSSElement)ASiCManifestElement.ASIC_MANIFEST);
        documentDom.appendChild(asicManifestDom);
        return asicManifestDom;
    }

    protected void addSigReference(Document documentDom, Element asicManifestDom) {
        Element sigReferenceDom = DomUtils.addElement((Document)documentDom, (Element)asicManifestDom, (DSSNamespace)ASiCManifestNamespace.NS, (DSSElement)ASiCManifestElement.SIG_REFERENCE);
        sigReferenceDom.setAttribute(ASiCManifestAttribute.URI.getAttributeName(), DSSUtils.encodeURI((String)this.sigReferenceUri));
        MimeType sigReferenceMimeType = this.getSigReferenceMimeType();
        if (sigReferenceMimeType != null) {
            sigReferenceDom.setAttribute(ASiCManifestAttribute.MIME_TYPE.getAttributeName(), sigReferenceMimeType.getMimeTypeString());
        }
    }

    protected abstract MimeType getSigReferenceMimeType();

    protected void addDataObjectReferences(Document documentDom, Element asicManifestDom) {
        ASiCContentDocumentFilter documentFilter = this.getAsicContentDocumentFilter();
        Objects.requireNonNull(documentFilter, "ASiCContentDocumentFilter cannot be null!");
        for (DSSDocument document : documentFilter.filter(this.asicContent)) {
            this.addDataObjectReference(documentDom, asicManifestDom, document, this.digestAlgorithm);
        }
    }

    protected ASiCContentDocumentFilter getAsicContentDocumentFilter() {
        if (this.asicContentDocumentFilter == null) {
            this.asicContentDocumentFilter = this.initDefaultAsicContentDocumentFilter();
        }
        return this.asicContentDocumentFilter;
    }

    public AbstractASiCManifestBuilder setAsicContentDocumentFilter(ASiCContentDocumentFilter asicContentDocumentFilter) {
        this.asicContentDocumentFilter = asicContentDocumentFilter;
        return this;
    }

    protected abstract ASiCContentDocumentFilter initDefaultAsicContentDocumentFilter();

    protected Element addDataObjectReference(Document documentDom, Element asicManifestDom, DSSDocument document, DigestAlgorithm digestAlgorithm) {
        Element dataObjectReferenceDom = DomUtils.addElement((Document)documentDom, (Element)asicManifestDom, (DSSNamespace)ASiCManifestNamespace.NS, (DSSElement)ASiCManifestElement.DATA_OBJECT_REFERENCE);
        dataObjectReferenceDom.setAttribute(ASiCManifestAttribute.URI.getAttributeName(), DSSUtils.encodeURI((String)document.getName()));
        MimeType mimeType = document.getMimeType();
        if (mimeType != null) {
            dataObjectReferenceDom.setAttribute(ASiCManifestAttribute.MIME_TYPE.getAttributeName(), mimeType.getMimeTypeString());
        }
        if (this.isRootfile(document)) {
            dataObjectReferenceDom.setAttribute(ASiCManifestAttribute.ROOTFILE.getAttributeName(), "true");
        }
        Element digestMethodDom = DomUtils.addElement((Document)documentDom, (Element)dataObjectReferenceDom, (DSSNamespace)XMLDSigNamespace.NS, (DSSElement)XMLDSigElement.DIGEST_METHOD);
        digestMethodDom.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), digestAlgorithm.getUri());
        Element digestValueDom = DomUtils.addElement((Document)documentDom, (Element)dataObjectReferenceDom, (DSSNamespace)XMLDSigNamespace.NS, (DSSElement)XMLDSigElement.DIGEST_VALUE);
        Text textNode = documentDom.createTextNode(Utils.toBase64((byte[])document.getDigestValue(digestAlgorithm)));
        digestValueDom.appendChild(textNode);
        return dataObjectReferenceDom;
    }

    protected boolean isRootfile(DSSDocument document) {
        return false;
    }

    protected DSSDocument toDSSDocument(Document documentDom) {
        String newManifestName = this.getManifestFilename();
        return DomUtils.createDssDocumentFromDomDocument((Document)documentDom, (String)newManifestName);
    }

    protected abstract String getManifestFilename();
}

