/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox.visible.nativedrawer;

import java.awt.Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;

public class PdfBoxFontMapper {
    private PdfBoxFontMapper() {
    }

    public static PDType1Font getPDFont(Font javaFont) {
        Standard14Fonts.FontName fontName = PdfBoxFontMapper.getFontName(javaFont);
        return new PDType1Font(fontName);
    }

    private static Standard14Fonts.FontName getFontName(Font javaFont) {
        switch (javaFont.getFamily()) {
            case "Serif": {
                if (javaFont.isPlain()) {
                    return Standard14Fonts.FontName.TIMES_ROMAN;
                }
                if (javaFont.isBold()) {
                    if (javaFont.isItalic()) {
                        return Standard14Fonts.FontName.TIMES_BOLD_ITALIC;
                    }
                    return Standard14Fonts.FontName.TIMES_BOLD;
                }
                return Standard14Fonts.FontName.TIMES_ITALIC;
            }
            case "SansSerif": {
                if (javaFont.isPlain()) {
                    return Standard14Fonts.FontName.HELVETICA;
                }
                if (javaFont.isBold()) {
                    if (javaFont.isItalic()) {
                        return Standard14Fonts.FontName.HELVETICA_BOLD_OBLIQUE;
                    }
                    return Standard14Fonts.FontName.HELVETICA_BOLD;
                }
                return Standard14Fonts.FontName.HELVETICA_OBLIQUE;
            }
            case "Monospaced": {
                if (javaFont.isPlain()) {
                    return Standard14Fonts.FontName.COURIER;
                }
                if (javaFont.isBold()) {
                    if (javaFont.isItalic()) {
                        return Standard14Fonts.FontName.COURIER_BOLD_OBLIQUE;
                    }
                    return Standard14Fonts.FontName.COURIER_BOLD;
                }
                return Standard14Fonts.FontName.COURIER_OBLIQUE;
            }
            case "Dialog": 
            case "DialogInput": {
                return Standard14Fonts.FontName.SYMBOL;
            }
        }
        throw new UnsupportedOperationException("The font is not supported! Please use DSSFileFont implementation for custom fonts.");
    }
}

