/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer;

import eu.europa.esig.dss.pdf.visible.AbstractDSSFontMetrics;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class JavaDSSFontMetrics
extends AbstractDSSFontMetrics {
    private Font javaFont;
    private FontMetrics fontMetrics;

    public JavaDSSFontMetrics(Font javaFont) {
        this.javaFont = javaFont;
    }

    private FontMetrics getFontMetrics(float fontSize) {
        if (this.fontMetrics != null && (float)this.javaFont.getSize() == fontSize) {
            return this.fontMetrics;
        }
        this.javaFont = this.javaFont.deriveFont(fontSize);
        BufferedImage img = new BufferedImage(1, 1, 1);
        Graphics g = img.getGraphics();
        g.setFont(this.javaFont);
        this.fontMetrics = g.getFontMetrics(this.javaFont);
        g.dispose();
        return this.fontMetrics;
    }

    public float getWidth(String str, float size) {
        return this.getFontMetrics(size).stringWidth(str);
    }

    public float getHeight(String str, float size) {
        return (float)this.getFontMetrics(size).getHeight() / 1.05f;
    }

    public float getMaxAscent(float size) {
        return this.getFontMetrics(size).getMaxAscent();
    }
}

