/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pdf.PdfArray;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.PdfObject;
import eu.europa.esig.dss.pdf.PdfSimpleObject;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxDict;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxObjectKey;
import eu.europa.esig.dss.spi.DSSUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PdfBoxArray
implements PdfArray {
    private static final Logger LOG = LoggerFactory.getLogger(PdfBoxArray.class);
    private final COSArray wrapped;
    private final PDDocument document;
    private final PdfObject parent;

    public PdfBoxArray(PDDocument document) {
        this(new COSArray(), document);
    }

    public PdfBoxArray(COSArray wrapped, PDDocument document) {
        this(wrapped, document, null);
    }

    public PdfBoxArray(COSArray wrapped, PDDocument document, PdfObject parent) {
        Objects.requireNonNull(wrapped, "Pdf array shall be provided!");
        Objects.requireNonNull(document, "Pdf document shall be provided!");
        this.wrapped = wrapped;
        this.document = document;
        this.parent = parent;
    }

    public COSArray getValue() {
        return this.wrapped;
    }

    public PdfObject getParent() {
        return this.parent;
    }

    public int size() {
        return this.wrapped.size();
    }

    public byte[] getStreamBytes(int i) throws IOException {
        COSBase val = this.wrapped.get(i);
        return this.toBytes(val);
    }

    private byte[] toBytes(COSBase val) throws IOException {
        COSObject o;
        COSBase object;
        COSStream cosStream = null;
        if (val instanceof COSObject && (object = (o = (COSObject)val).getObject()) instanceof COSStream) {
            cosStream = (COSStream)object;
        }
        if (cosStream == null) {
            throw new DSSException("Cannot find value for " + val + " of class " + val.getClass());
        }
        try (COSInputStream is = cosStream.createInputStream();){
            byte[] byArray = DSSUtils.toByteArray((InputStream)is);
            return byArray;
        }
    }

    @Deprecated
    public Long getObjectNumber(int i) {
        PdfBoxObjectKey objectKey = this.getObjectKey(i);
        if (objectKey != null) {
            return objectKey.getValue().getNumber();
        }
        return null;
    }

    public PdfBoxObjectKey getObjectKey(int i) {
        COSBase val = this.wrapped.get(i);
        if (val instanceof COSObject) {
            return new PdfBoxObjectKey(val.getKey());
        }
        return null;
    }

    public Number getNumber(int i) {
        COSBase val = this.wrapped.get(i);
        if (val != null) {
            if (val instanceof COSInteger) {
                return ((COSInteger)val).longValue();
            }
            if (val instanceof COSNumber) {
                return Float.valueOf(((COSNumber)val).floatValue());
            }
        }
        return null;
    }

    public String getString(int i) {
        return this.wrapped.getString(i);
    }

    public PdfDict getAsDict(int i) {
        COSDictionary cosDictionary = null;
        COSBase cosBaseObject = this.wrapped.get(i);
        if (cosBaseObject instanceof COSDictionary) {
            cosDictionary = (COSDictionary)cosBaseObject;
        } else if (cosBaseObject instanceof COSObject) {
            COSObject cosObject = (COSObject)cosBaseObject;
            cosDictionary = (COSDictionary)cosObject.getObject();
        }
        if (cosDictionary != null) {
            return new PdfBoxDict(cosDictionary, this.document, (PdfObject)this);
        }
        LOG.warn("Unable to extract array entry as dictionary!");
        return null;
    }

    public PdfObject getObject(int i) {
        COSBase dictionaryObject = this.wrapped.getObject(i);
        if (dictionaryObject == null) {
            return null;
        }
        if (dictionaryObject instanceof COSDictionary || dictionaryObject instanceof COSObject) {
            return this.getAsDict(i);
        }
        if (dictionaryObject instanceof COSArray) {
            return new PdfBoxArray((COSArray)dictionaryObject, this.document, (PdfObject)this);
        }
        if (dictionaryObject instanceof COSString) {
            return new PdfSimpleObject((Object)this.getString(i), (PdfObject)this);
        }
        if (dictionaryObject instanceof COSName) {
            return new PdfSimpleObject((Object)this.wrapped.getName(i), (PdfObject)this);
        }
        if (dictionaryObject instanceof COSNumber) {
            return new PdfSimpleObject((Object)this.getNumber(i), (PdfObject)this);
        }
        if (dictionaryObject instanceof COSBoolean) {
            return new PdfSimpleObject((Object)((COSBoolean)dictionaryObject).getValueAsObject(), (PdfObject)this);
        }
        if (dictionaryObject instanceof COSNull) {
            return null;
        }
        LOG.warn("Unable to process an entry on position '{}' of type '{}'.", (Object)i, dictionaryObject.getClass());
        return null;
    }

    public void addObject(PdfObject pdfObject) {
        Object value = pdfObject.getValue();
        if (!(value instanceof COSBase)) {
            throw new UnsupportedOperationException("The object to be added shall be of type COSBase!");
        }
        this.wrapped.add((COSBase)value);
    }

    public void setDirect(boolean direct) {
        this.wrapped.setDirect(direct);
    }

    public String toString() {
        return this.wrapped.toString();
    }
}

