/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.usb.impl;

import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.usb.USB;
import com.anf.cryptotoken.usb.USBController;
import com.anf.cryptotoken.usb.USBFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;

public class LinuxUSBController
implements USBController {
    private static final Logger log = Logger.getLogger(LinuxUSBController.class);
    HashMap<String, String> unidadesConectadas = new HashMap();
    ArrayList<USB> usbs = new ArrayList();

    public LinuxUSBController() {
        this.unidadesConectadas.clear();
        this.usbs.clear();
        if (System.getProperty("os.name").contains("Linux")) {
            this.unidadesConectadas();
        } else {
            log.info((Object)System.getProperty("os.name"));
        }
    }

    private void unidadesConectadas() {
        try {
            String uuidLine;
            String mountPathline;
            Process listUUIDProccess = Runtime.getRuntime().exec("ls -l /dev/disk/by-uuid");
            int resultListUUID = listUUIDProccess.waitFor();
            if (resultListUUID != 0) {
                throw new IOException("ERR_LIST_UUID_USB (ls -l /dev/disk/by-uuid) returns " + resultListUUID);
            }
            InputStream streamUUID = listUUIDProccess.getInputStream();
            byte[] outUUID = IOUtils.toByteArray((InputStream)streamUUID);
            String strUUIDList = new String(outUUID);
            String listPathCommand = "df --output=source,target";
            listPathCommand = "findmnt -o source,target";
            Process listUSBPaths = Runtime.getRuntime().exec(listPathCommand);
            int resultListUSBPaths = listUSBPaths.waitFor();
            if (resultListUSBPaths != 0) {
                throw new IOException("ERR_LIST_USB_PATHS (" + listPathCommand + ") returns " + resultListUSBPaths);
            }
            InputStream streamUSBPaths = listUSBPaths.getInputStream();
            byte[] outListUSBPaths = IOUtils.toByteArray((InputStream)streamUSBPaths);
            String outputListUSBPaths = new String(outListUSBPaths);
            TreeMap<String, CallSite> mountPaths = new TreeMap<String, CallSite>();
            BufferedReader readerUSBPaths = new BufferedReader(new StringReader(outputListUSBPaths));
            while (readerUSBPaths.ready() && (mountPathline = readerUSBPaths.readLine()) != null) {
                String mountKey;
                String[] split2;
                String[] split;
                mountPathline = mountPathline.trim();
                String separator = "\u2500/";
                separator = "\u2500/";
                int locationOfPath = mountPathline.indexOf(separator);
                if (locationOfPath == -1 || (split = mountPathline.split(separator)).length != 2 || (split2 = (mountKey = split[0].trim()).split(" ")).length < 2) continue;
                mountKey = split2[0].trim();
                int locationOfLastSeparator = mountKey.lastIndexOf("/");
                if (locationOfLastSeparator != -1) {
                    mountKey = mountKey.substring(locationOfLastSeparator);
                }
                String path = "/" + split[1].trim();
                mountPaths.put(mountKey, (CallSite)((Object)path));
            }
            BufferedReader readerUUID = new BufferedReader(new StringReader(strUUIDList));
            while (readerUUID.ready() && (uuidLine = readerUUID.readLine()) != null) {
                String[] split;
                Object uuid;
                if (uuidLine.contains("../../sda") || !uuidLine.contains("../../sd") && !uuidLine.contains("../../sdb") && !uuidLine.contains("../../sdc") && !uuidLine.contains("../../sdd") && !uuidLine.contains("../../sde") && !uuidLine.contains("../../sdf")) continue;
                int lastIndexOf = uuidLine.lastIndexOf("/");
                String mount = uuidLine.substring(lastIndexOf);
                String path = (String)mountPaths.get(mount);
                if (mount == null || path == null || (uuid = this.detectSerialNumber(split = uuidLine.split(" "))) == null) continue;
                log.info((Object)("mounted in: " + mount + ", path: " + path + ", uuid:" + (String)uuid));
                File fp = new File(path);
                log.info((Object)(fp + " existe: " + (fp.exists() && fp.canWrite())));
                if (!fp.exists() || !fp.canWrite()) continue;
                uuid = ((String)uuid).replace("-", "");
                uuid = "" + Long.parseLong((String)uuid, 16);
                this.unidadesConectadas.put((String)uuid, path);
            }
        }
        catch (IOException | InterruptedException e) {
            log.error((Object)e);
        }
        this.cargarUSBs();
    }

    private String detectSerialNumber(String[] split) {
        for (int i = 0; i < split.length; ++i) {
            String text = split[i].trim();
            if (text.contains("-")) {
                String[] div = text.split("-");
                if (div.length != 2 || div[0].length() != 4 || div[1].length() != 4) continue;
                return text;
            }
            if (i != split.length - 3 || text.length() != 16) continue;
            return text.substring(8, 12) + "-" + text.substring(12);
        }
        return null;
    }

    private void cargarUSBs() {
        this.unidadesConectadas.entrySet().forEach(e -> this.usbs.add(USBFactory.newUSB((String)e.getValue(), (String)e.getKey())));
    }

    @Override
    public ArrayList<USB> getUSBUnits() {
        return this.usbs;
    }
}

