/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs11.provider.model;

import com.anf.pkcs11.jna.PKCS11Exception;
import com.anf.pkcs11.provider.model.JNAToken;
import com.anf.pkcs11.provider.model.Session;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

final class SessionRef
extends PhantomReference<Session>
implements Comparable<SessionRef> {
    private static ReferenceQueue<Session> refQueue = new ReferenceQueue();
    private static Set<SessionRef> refList = Collections.synchronizedSortedSet(new TreeSet());
    private long id;
    private JNAToken token;

    static ReferenceQueue<Session> referenceQueue() {
        return refQueue;
    }

    static int totalCount() {
        return refList.size();
    }

    private static void drainRefQueueBounded() {
        SessionRef next;
        while ((next = (SessionRef)refQueue.poll()) != null) {
            next.dispose();
        }
    }

    SessionRef(Session session, long id, JNAToken token) {
        super(session, refQueue);
        this.id = id;
        this.token = token;
        refList.add(this);
        SessionRef.drainRefQueueBounded();
    }

    void dispose() {
        refList.remove(this);
        try {
            if (this.token.isPresent(this.id)) {
                this.token.p11().C_CloseSession(this.id);
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
        }
        finally {
            this.clear();
        }
    }

    @Override
    public int compareTo(SessionRef other) {
        if (this.id == other.id) {
            return 0;
        }
        return this.id < other.id ? -1 : 1;
    }
}

