/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs11.provider.model;

import com.anf.pkcs11.provider.model.JNAToken;
import com.anf.pkcs11.provider.model.SessionRef;
import java.security.ProviderException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Session
implements Comparable<Session> {
    private static final Logger log = LogManager.getLogger(Session.class);
    private static final long MAX_IDLE_TIME = 180000L;
    final JNAToken token;
    private final long id;
    private final AtomicInteger createdObjects;
    private long lastAccess;
    private final SessionRef sessionRef;

    Session(JNAToken token, long id) {
        this.token = token;
        this.id = id;
        this.createdObjects = new AtomicInteger();
        this.id();
        this.sessionRef = new SessionRef(this, id, token);
    }

    @Override
    public int compareTo(Session other) {
        if (this.lastAccess == other.lastAccess) {
            return 0;
        }
        return this.lastAccess < other.lastAccess ? -1 : 1;
    }

    boolean isLive(long currentTime) {
        return currentTime - this.lastAccess < 180000L;
    }

    long idInternal() {
        return this.id;
    }

    public long id() {
        if (!this.token.isPresent(this.id)) {
            throw new ProviderException("Token has been removed");
        }
        this.lastAccess = System.currentTimeMillis();
        return this.id;
    }

    void addObject() {
        this.createdObjects.incrementAndGet();
        log.info("agregado un objeto de la sesion {}, quedan {} objetos", (Object)this.id, (Object)this.createdObjects.get());
    }

    void removeObject() {
        this.createdObjects.decrementAndGet();
        log.info("eliminado un objeto de la sesion {}, quedan {} objetos", (Object)this.id, (Object)this.createdObjects.get());
    }

    boolean hasObjects() {
        return this.createdObjects.get() != 0;
    }

    void close() {
        if (this.hasObjects()) {
            throw new ProviderException("Internal error: close session with active objects");
        }
        this.sessionRef.dispose();
    }

    public String toString() {
        return "[id:" + this.id + " objs: " + this.createdObjects.get() + "]";
    }
}

