/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs11.provider.model;

import com.anf.pkcs11.provider.model.Session;
import java.math.BigInteger;

public abstract class JNAKey {
    protected long keyHandle;
    protected byte[] id;
    protected BigInteger modulus;
    protected String algorithm;
    protected Session session;

    protected JNAKey(Session session, long keyHandle, byte[] id, BigInteger modulus, String algorithm) {
        this.session = session;
        this.keyHandle = keyHandle;
        this.id = id;
        this.modulus = modulus;
        this.algorithm = algorithm;
        session.addObject();
    }

    public int getKeySize() {
        return this.modulus.bitLength();
    }

    public Session getSession() {
        return this.session;
    }

    public Session setSession(Session session) {
        Session old = null;
        if (session != null) {
            old = this.session;
            this.session = session;
        }
        return old;
    }

    public long getKeyHandle() {
        return this.keyHandle;
    }

    public void setId(byte[] id) {
        this.id = id;
    }

    public byte[] getId() {
        return this.id;
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String toString() {
        return "key id: " + this.keyHandle + ", cka_id: " + new String(this.id) + " , session: " + this.session;
    }
}

