/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs11.provider.impl;

import com.anf.pkcs11.jna.CK_ATTRIBUTE;
import com.anf.pkcs11.provider.model.CertInfo;
import com.anf.pkcs11.provider.model.JNAPrivateKey;
import com.anf.pkcs11.provider.model.JNAToken;
import com.anf.pkcs11.provider.model.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JNAKeyStore
extends KeyStoreSpi {
    private static final Logger log = LogManager.getLogger(JNAKeyStore.class);
    private JNAToken token;
    private boolean updateCert = false;

    public JNAKeyStore(JNAToken token) {
        this.token = token;
    }

    @Override
    public synchronized Enumeration<String> engineAliases() {
        return this.token.aliases();
    }

    @Override
    public boolean engineContainsAlias(String arg0) {
        return this.token.containsKey(arg0);
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        Long certId;
        CertInfo certInfo = this.token.getCertInfo(alias);
        if (certInfo == null) {
            certInfo = this.token.getCaInfo(alias);
        }
        if (certInfo == null) {
            return;
        }
        Session opSession = certInfo.getSession();
        if (!this.token.delete(certInfo, true) && this.token.isLoggedInNow(opSession) && (certId = this.token.p11().findCertificate(opSession.id(), alias)) != null) {
            CK_ATTRIBUTE id = new CK_ATTRIBUTE(258L);
            this.token.p11().C_GetAttributeValue(opSession.id(), certId, new CK_ATTRIBUTE[]{id});
            Long keyId = this.token.p11().findPrivateKey(opSession.id(), id.getValue());
            if (keyId != null) {
                this.token.p11().C_DestroyObject(opSession.id(), keyId);
            }
        }
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        return this.token.getCertificate(alias);
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        return this.token.getAlias(cert);
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        return this.token.getCertificateChain(alias);
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        CertInfo info = this.token.getCertInfo(alias);
        if (info != null) {
            return info.getDate();
        }
        return null;
    }

    @Override
    public Key engineGetKey(String alias, char[] pin) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        CertInfo certInfo = this.token.getCertInfo(alias);
        if (certInfo == null || certInfo.getPrivateKey() == null) {
            throw new UnrecoverableKeyException();
        }
        Session session = certInfo.getPrivateKey().getSession();
        if (!this.token.isLoggedInNow(session) && pin != null) {
            session = this.token.logIn(pin);
            Session old = certInfo.getPrivateKey().setSession(session);
            this.token.freeSession(old);
        }
        this.token.ensureLoggedIn(session);
        if (certInfo.getPrivateKey() != null) {
            return certInfo.getPrivateKey();
        }
        Long privateKeyId = this.token.p11().findPrivateKey(session.id(), certInfo.getId());
        RSAPublicKey publicKey = (RSAPublicKey)certInfo.getCert().getPublicKey();
        JNAPrivateKey privateKey = new JNAPrivateKey(session, privateKeyId, certInfo.getId(), publicKey.getModulus(), publicKey.getAlgorithm());
        certInfo.setPrivateKey(privateKey);
        return privateKey;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return this.token.getCertInfo(alias) != null;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        try {
            return null != this.engineGetKey(alias, null);
        }
        catch (Exception e) {
            log.warn("error obteniendo llave de alias {}", (Object)alias, (Object)e);
            return false;
        }
    }

    @Override
    public void engineLoad(InputStream arg0, char[] pin) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.token.fillCertificates();
        if (pin != null) {
            Session session = this.token.logIn(pin);
            this.token.updateKeys(session);
        }
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        try {
            this.insertCertificate(cert, alias.getBytes(), alias);
        }
        catch (CertificateEncodingException e) {
            throw new KeyStoreException(e);
        }
    }

    private CertInfo insertCertificate(Certificate c, byte[] id, String label) throws CertificateEncodingException {
        X509Certificate cert = (X509Certificate)c;
        boolean ca = cert.getBasicConstraints() != -1;
        label = ca ? cert.getSerialNumber().toString() : label;
        CertInfo existing = this.token.getCertInfo(label);
        if (existing == null) {
            existing = this.token.getCaInfo(label);
        }
        Session session = this.token.getLastSession();
        if (existing != null) {
            if (!Arrays.equals(existing.getCert().getSignature(), cert.getSignature())) {
                if (this.updateCert) {
                    this.updateCert(id, label, cert, existing, session);
                } else {
                    this.recreateCert(id, label, cert, existing, session);
                }
            }
            log.debug("no need to create a new cert, returning existing with alias {}", (Object)label);
            return existing;
        }
        this.token.dump();
        long obj = this.createCert(id, label, cert, session);
        log.info("cert created with id: {}, label: {}, serial: {} with obj id: {}", (Object)new String(id), (Object)label, (Object)cert.getSerialNumber(), (Object)obj);
        CertInfo certInfo = new CertInfo(session, label, id, obj, cert);
        this.token.insert(certInfo);
        return certInfo;
    }

    private void recreateCert(byte[] id, String label, X509Certificate cert, CertInfo existing, Session session) throws CertificateEncodingException {
        this.token.p11().C_DestroyObject(session.id(), existing.getObjectId());
        long obj = this.createCert(id, label, cert, session);
        existing.setObjectId(obj);
        existing.setCert(this.token.p11().getCertificate(existing.getSession().id(), existing.getObjectId()));
        if (log.isInfoEnabled()) {
            if (Arrays.equals(existing.getCert().getSignature(), cert.getSignature())) {
                log.info("updated cert with id: {}, label: {}, serial: {} with obj id: {}", (Object)new String(id), (Object)label, (Object)cert.getSerialNumber(), (Object)existing.getObjectId());
            } else {
                log.info("cert not updated with id: {}, label: {}, serial: {} with obj id: {}", (Object)new String(id), (Object)label, (Object)cert.getSerialNumber(), (Object)existing.getObjectId());
            }
        }
    }

    private long createCert(byte[] id, String label, X509Certificate cert, Session session) throws CertificateEncodingException {
        boolean ca = cert.getBasicConstraints() != -1;
        CK_ATTRIBUTE[] pTemplate = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(368L, true), new CK_ATTRIBUTE(0L, 1L), new CK_ATTRIBUTE(128L, 0L), new CK_ATTRIBUTE(135L, ca ? 2 : 1), new CK_ATTRIBUTE(257L, cert.getSubjectX500Principal().getEncoded()), new CK_ATTRIBUTE(129L, cert.getIssuerX500Principal().getEncoded()), new CK_ATTRIBUTE(130L, cert.getSerialNumber().toByteArray()), new CK_ATTRIBUTE(17L, cert.getEncoded()), new CK_ATTRIBUTE(258L, ca ? cert.getSerialNumber().toByteArray() : id), new CK_ATTRIBUTE(3L, label)};
        long obj = this.token.p11().C_CreateObject(session.id(), pTemplate);
        if (log.isInfoEnabled()) {
            log.info("cert created with id: {}, label: {}, serial: {} with obj id: {}", (Object)new String(id), (Object)label, (Object)cert.getSerialNumber(), (Object)obj);
        }
        return obj;
    }

    private void updateCert(byte[] id, String label, X509Certificate cert, CertInfo existing, Session session) throws CertificateEncodingException {
        CK_ATTRIBUTE[] pTemplate = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(129L, cert.getIssuerX500Principal().getEncoded()), new CK_ATTRIBUTE(130L, cert.getSerialNumber().toByteArray()), new CK_ATTRIBUTE(17L, cert.getEncoded())};
        if (log.isInfoEnabled()) {
            log.info("updating cert with id: {}, label: {}, serial: {} with obj id: {}", (Object)new String(id), (Object)label, (Object)cert.getSerialNumber(), (Object)existing.getObjectId());
        }
        this.token.p11().C_SetAttributeValue(session.id(), existing.getObjectId(), pTemplate);
        existing.setCert(this.token.p11().getCertificate(existing.getSession().id(), existing.getObjectId()));
        if (log.isInfoEnabled()) {
            if (Arrays.equals(existing.getCert().getSignature(), cert.getSignature())) {
                log.info("updated cert with id: {}, label: {}, serial: {} with obj id: {}", (Object)new String(id), (Object)label, (Object)cert.getSerialNumber(), (Object)existing.getObjectId());
            } else {
                log.info("cert not updated with id: {}, label: {}, serial: {} with obj id: {}", (Object)new String(id), (Object)label, (Object)cert.getSerialNumber(), (Object)existing.getObjectId());
            }
        }
    }

    @Override
    public void engineSetKeyEntry(String arg0, byte[] arg1, Certificate[] arg2) throws KeyStoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] pin, Certificate[] chain) throws KeyStoreException {
        JNAPrivateKey privateKey;
        if (key instanceof JNAPrivateKey) {
            privateKey = (JNAPrivateKey)key;
            for (Certificate c : chain) {
                try {
                    CertInfo info = this.insertCertificate(c, alias.getBytes(), alias);
                    if (info.isCa()) continue;
                    info.setPrivateKey(privateKey);
                }
                catch (CertificateEncodingException e) {
                    throw new KeyStoreException(e);
                }
            }
            this.token.dump();
            Session session = privateKey.getSession();
            log.debug("private key {} session: {}", (Object)privateKey.getKeyHandle(), (Object)privateKey.getSession().id());
            this.token.ensureLoggedIn(session);
            long privateKeyId = privateKey.getKeyHandle();
            CK_ATTRIBUTE id = new CK_ATTRIBUTE(258L);
            this.token.p11().C_GetAttributeValue(session.id(), privateKeyId, new CK_ATTRIBUTE[]{id});
            id = new CK_ATTRIBUTE(258L, alias);
            CK_ATTRIBUTE label = new CK_ATTRIBUTE(3L, alias);
            CK_ATTRIBUTE[] update = new CK_ATTRIBUTE[]{id, label};
            this.token.p11().C_SetAttributeValue(session.id(), privateKeyId, update);
            if (log.isInfoEnabled()) {
                log.info("key pair CKA_ID changed from {} to: {}", (Object)new String(privateKey.getId()), (Object)alias);
            }
        } else {
            throw new KeyStoreException(new InvalidKeyException("private key must be instance of JNAPrivateKey"));
        }
        privateKey.setId(alias.getBytes());
    }

    @Override
    public int engineSize() {
        return this.token.size();
    }

    @Override
    public void engineStore(OutputStream arg0, char[] arg1) throws IOException, NoSuchAlgorithmException, CertificateException {
        log.warn("store not supported in PKCS11");
    }
}

