/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs11.provider.impl;

import com.anf.pkcs11.jna.CKM;
import com.anf.pkcs11.jna.CK_ATTRIBUTE;
import com.anf.pkcs11.jna.LongRef;
import com.anf.pkcs11.jna.PKCS11Exception;
import com.anf.pkcs11.provider.model.JNAPrivateKey;
import com.anf.pkcs11.provider.model.JNAToken;
import com.anf.pkcs11.provider.model.Session;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPublicKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JNAKeyPairGenerator
extends KeyPairGenerator {
    private static final Logger log = LogManager.getLogger(JNAKeyPairGenerator.class);
    private JNAToken token;
    private RSAKeyGenParameterSpec params;
    private SecureRandom random;
    private long mechanismType;
    private long keyType;

    public JNAKeyPairGenerator(String algorithm, long keyType, long mechanism, JNAToken token) {
        super(algorithm);
        this.mechanismType = mechanism;
        this.token = token;
        this.keyType = keyType;
    }

    @Override
    public void initialize(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.initialize(params, new SecureRandom());
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        RSAKeyGenParameterSpec rsa;
        super.initialize(params, random);
        if (!(params instanceof RSAKeyGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("INVALID_KEY_GEN_ALGORITHM");
        }
        this.params = rsa = (RSAKeyGenParameterSpec)params;
        this.random = random;
    }

    @Override
    public KeyPair generateKeyPair() {
        Session session = this.token.getLastSession();
        this.token.ensureLoggedIn(session);
        CKM mechanism = new CKM(this.mechanismType, null);
        int keySize = this.params.getKeysize();
        String label = this.random();
        CK_ATTRIBUTE[] publicKeyTemplate = this.publicKeyTemplate(keySize, label);
        CK_ATTRIBUTE[] privateKeyTemplate = this.privateKeyTemplate(keySize, label);
        LongRef publicKey = new LongRef();
        LongRef privateKey = new LongRef();
        log.info("Generating {} key pair with label {}", (Object)this.getAlgorithm(), (Object)label);
        this.token.p11().C_GenerateKeyPair(session.id(), mechanism, publicKeyTemplate, privateKeyTemplate, publicKey, privateKey);
        log.info("{} Key Pair generated, private key obj handle: {}, public key object handle: {}", (Object)this.getAlgorithm(), (Object)privateKey.value, (Object)publicKey.value);
        RSAPublicKey pubKey = this.buildPublicKeyObject(session, publicKey);
        log.info("destruyendo objeto pkcs11 de llave publica con id: {}", (Object)publicKey.value);
        this.token.p11().C_DestroyObject(session.id(), publicKey.value);
        JNAPrivateKey privKey = new JNAPrivateKey(session, privateKey.value, label.getBytes(), pubKey.getModulus(), this.getAlgorithm());
        return new KeyPair(pubKey, privKey);
    }

    private CK_ATTRIBUTE[] privateKeyTemplate(int keySize, String label) {
        return new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(354L, false), new CK_ATTRIBUTE(2L, true), new CK_ATTRIBUTE(259L, true), new CK_ATTRIBUTE(264L, true), new CK_ATTRIBUTE(256L, this.keyType), new CK_ATTRIBUTE(258L, label), new CK_ATTRIBUTE(3L, label)};
    }

    private CK_ATTRIBUTE[] publicKeyTemplate(int keySize, String label) {
        return new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(266L, true), new CK_ATTRIBUTE(289L, keySize), new CK_ATTRIBUTE(290L, RSAKeyGenParameterSpec.F4), new CK_ATTRIBUTE(256L, this.keyType), new CK_ATTRIBUTE(258L, label), new CK_ATTRIBUTE(3L, label)};
    }

    private RSAPublicKey buildPublicKeyObject(Session session, LongRef publicKey) {
        RSAPublicKey pubKey;
        CK_ATTRIBUTE pubKeyValue = new CK_ATTRIBUTE(288L);
        this.token.p11().C_GetAttributeValue(session.id(), publicKey.value, new CK_ATTRIBUTE[]{pubKeyValue});
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(new BigInteger(1, pubKeyValue.pValue), RSAKeyGenParameterSpec.F4, this.params);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            pubKey = (RSAPublicKey)keyFactory.generatePublic(publicKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new PKCS11Exception(32L, (Throwable)e);
        }
        return pubKey;
    }

    private String random() {
        return new BigInteger(130, this.random).toString(32).substring(0, 10);
    }
}

