/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs11.provider.cert;

import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.x500.X500Principal;

public class CertService {
    public static Certificate[] buildChain(X509Certificate cert, List<X509Certificate> caCerts) {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        certs.add(cert);
        boolean findRoot = false;
        X509Certificate cursor = cert;
        while (!findRoot) {
            boolean found = false;
            for (X509Certificate ca : caCerts) {
                if (!CertService.checkIssuer(ca, cursor)) continue;
                certs.add(ca);
                cursor = ca;
                found = true;
                break;
            }
            if (!found) break;
            findRoot = CertService.isSelfSigned(cursor);
        }
        return certs.toArray(new Certificate[0]);
    }

    public static boolean isSelfSigned(X509Certificate cur) {
        return cur.getSubjectX500Principal().equals(cur.getIssuerX500Principal());
    }

    public static boolean checkIssuer(X509Certificate issuer, X509Certificate uploaded) {
        X500Principal issuerDN;
        X500Principal subjectDN = issuer.getSubjectX500Principal();
        if (!subjectDN.equals(issuerDN = uploaded.getIssuerX500Principal())) {
            return false;
        }
        PublicKey pubKey = issuer.getPublicKey();
        try {
            uploaded.verify(pubKey);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

