/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs11.provider;

import com.anf.pkcs11.jna.CKM;
import com.anf.pkcs11.jna.P11Manager;
import com.anf.pkcs11.provider.impl.SignatureAlgorithmParam;
import com.anf.pkcs11.provider.model.JNAToken;
import com.anf.pkcs11.provider.services.JNAKeyGeneratorService;
import com.anf.pkcs11.provider.services.JNAKeyStoreService;
import com.anf.pkcs11.provider.services.JNASignatureService;
import java.security.AuthProvider;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JNAProvider
extends AuthProvider {
    private static final Logger log = LogManager.getLogger(JNAProvider.class);
    private static final long serialVersionUID = 1L;
    public static final String NAME = "PKCS11";
    private JNAToken token;
    Map<Long, Supplier<Provider.Service>> serviceMap = new TreeMap<Long, Supplier<Provider.Service>>();
    private Provider provider = Security.getProvider("BC");

    public JNAProvider(String dll, long slot) {
        this(new P11Manager(dll), slot);
    }

    public JNAProvider(P11Manager p11, long slot) {
        super(NAME, "1", "JNA PKCS11 Security Provider");
        long[] mechanisms;
        this.token = new JNAToken(p11, slot);
        this.putService(new JNAKeyStoreService(this, this.token));
        this.serviceMap.put(0L, () -> new JNAKeyGeneratorService(this, this.token, "RSA", 0L, 0L));
        this.serviceMap.put(16L, () -> new JNAKeyGeneratorService(this, this.token, "DSA", 16L, 1L));
        this.serviceMap.put(1L, () -> this.signatureService(this.token, SignatureAlgorithmParam.RSA));
        for (long mechanism : mechanisms = this.token.p11().GetMechanismList(slot)) {
            this.addService(mechanism);
        }
        if (super.getService("Signature", "NONEwithRSA") != null) {
            if (super.getService("Signature", "SHA1withRSA") == null) {
                this.addService(6L, () -> this.signatureService(this.token, SignatureAlgorithmParam.SHA1_RSA));
            }
            if (super.getService("Signature", "SHA256withRSA") == null) {
                this.addService(64L, () -> this.signatureService(this.token, SignatureAlgorithmParam.SHA256_RSA));
            }
            if (super.getService("Signature", "SHA384withRSA") == null) {
                this.addService(65L, () -> this.signatureService(this.token, SignatureAlgorithmParam.SHA384_RSA));
            }
            if (super.getService("Signature", "SHA512withRSA") == null) {
                this.addService(66L, () -> this.signatureService(this.token, SignatureAlgorithmParam.SHA512_RSA));
            }
        }
        log.info("PKCS11 provider loaded from {} slot: {}", (Object)p11.getDllModule(), (Object)slot);
    }

    public JNAToken getToken() {
        return this.token;
    }

    private JNASignatureService signatureService(JNAToken token, SignatureAlgorithmParam param) {
        try {
            return new JNASignatureService(this, token, param);
        }
        catch (NoSuchAlgorithmException e) {
            log.warn("error construyendo servicio de firma para mecanismo: " + CKM.L2S(param.getMechanism()), (Throwable)e);
            return null;
        }
    }

    private void addService(long mechanism) {
        Supplier<Provider.Service> supplier = this.serviceMap.get(mechanism);
        this.addService(mechanism, supplier);
    }

    private void addService(long mechanism, Supplier<Provider.Service> supplier) {
        Provider.Service service;
        log.info("mechanism: {}", (Object)CKM.L2S(mechanism));
        if (supplier != null && (service = supplier.get()) != null) {
            log.info("add service for mechanism {}", (Object)CKM.L2S(mechanism));
            this.putService(service);
        }
    }

    @Override
    public Provider.Service getService(String arg0, String arg1) {
        log.info("getService({},{})", (Object)arg0, (Object)arg1);
        if (arg0 != null && (arg0.equals("SSLContext") || arg0.equals("AlgorithmParameters"))) {
            Provider jsseProvider = Security.getProvider("SunJSSE");
            return jsseProvider.getService(arg0, arg1);
        }
        Provider.Service service = super.getService(arg0, arg1);
        if (service == null && arg1.endsWith("Encryption")) {
            service = super.getService(arg0, arg1.replace("Encryption", ""));
        }
        if (service != null) {
            log.info("PKCS11 Service: {}", (Object)service);
        }
        if (service == null && (service = this.provider.getService(arg0, arg1)) != null) {
            log.info("default provider service: {}", (Object)service);
        }
        log.info("getService({},{}) returns {}", (Object)arg0, (Object)arg1, (Object)service);
        return service;
    }

    @Override
    public Object get(Object key) {
        Object obj = super.get(key);
        if (obj == null) {
            obj = this.provider.get(key);
        }
        return obj;
    }

    @Override
    public void login(Subject arg0, CallbackHandler arg1) throws LoginException {
    }

    @Override
    public void logout() throws LoginException {
    }

    @Override
    public void setCallbackHandler(CallbackHandler arg0) {
    }
}

