/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs11.jna;

import com.anf.cryptotoken.io.LockerImpl;
import com.anf.pkcs11.jna.CKM;
import com.anf.pkcs11.jna.CK_ATTRIBUTE;
import com.anf.pkcs11.jna.CK_C_INITIALIZE_ARGS;
import com.anf.pkcs11.jna.CK_MECHANISM_INFO;
import com.anf.pkcs11.jna.CK_SESSION_INFO;
import com.anf.pkcs11.jna.CK_SLOT_INFO;
import com.anf.pkcs11.jna.CK_TOKEN_INFO;
import com.anf.pkcs11.jna.LongRef;
import com.anf.pkcs11.jna.P11JNA;
import com.anf.pkcs11.jna.PKCS11Exception;
import com.anf.pkcs11.jna.PKCS11Impl;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.LongFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class P11Manager {
    private static final Logger log = LogManager.getLogger(P11Manager.class);
    private String dllModule;
    private boolean initialized = false;
    private PKCS11Impl pkcs11;

    public P11Manager(String dllModule) {
        this.dllModule = dllModule;
        this.pkcs11 = P11JNA.getPKCS11Impl(dllModule);
    }

    public String getDllModule() {
        return this.dllModule;
    }

    public PKCS11Impl getPkcs11() {
        return this.pkcs11;
    }

    public void finalizeP11() {
        log.info("start finalize(" + this.initialized + ")");
        if (this.initialized && 0L == this.pkcs11.Finalize()) {
            this.initialized = false;
        }
        log.info("end finalize(" + this.initialized + ")");
    }

    public void initialize() {
        this.initialize(new CK_C_INITIALIZE_ARGS(null, null, null, null, 2L));
    }

    public void initialize(CK_C_INITIALIZE_ARGS args) {
        long err = 0L;
        log.info("start initialize(" + this.initialized + ")");
        if (!this.initialized) {
            err = this.pkcs11.Initialize(args);
            this.initialized = 0L == err;
        }
        log.info("end initialize(" + this.initialized + ")");
    }

    public long C_OpenSession(long slot, long flags) {
        LongRef sessionHandle = new LongRef();
        log.info("C_OpenSession slot:" + slot + ", flags: " + flags);
        long result = this.pkcs11.OpenSession(slot, flags, null, null, sessionHandle);
        log.info("C_OpenSession returns session id: " + sessionHandle.value + " in slot " + slot + ", flags: " + flags);
        this.validate(result);
        return sessionHandle.value;
    }

    public void C_CloseSession(long sessionHandle) {
        log.info("C_CloseSession: {}", (Object)sessionHandle);
        long result = this.pkcs11.CloseSession(sessionHandle);
        log.info("C_CloseSession returns : {}", (Object)result);
        this.validate(result);
    }

    public void C_Login(String soPINman, long user, long sh) {
        log.info("start C_Login");
        long login = this.pkcs11.Login(sh, user, soPINman == null ? null : soPINman.getBytes());
        log.info("end C_Login: " + login);
        this.validate(login);
    }

    public void C_FindObjectsInit(long sh, CK_ATTRIBUTE[] templ) {
        this.validate(this.pkcs11.FindObjectsInit(sh, templ));
    }

    public long[] C_FindObjects(long sh, int max) {
        LongRef count = new LongRef();
        long[] all = new long[max];
        this.validate(this.pkcs11.FindObjects(sh, all, count));
        long[] read = new long[(int)count.value];
        System.arraycopy(all, 0, read, 0, (int)count.value);
        return read;
    }

    public void C_FindObjectsFinal(long sh) {
        this.validate(this.pkcs11.FindObjectsFinal(sh));
    }

    public long C_CreateObject(long sh, CK_ATTRIBUTE[] templ) {
        LongRef objectHandle = new LongRef();
        this.validate(this.pkcs11.CreateObject(sh, templ, objectHandle));
        return objectHandle.value;
    }

    public void C_GenerateKeyPair(long session, CKM mechanism, CK_ATTRIBUTE[] publicKeyTemplate, CK_ATTRIBUTE[] privateKeyTemplate, LongRef publicKey, LongRef privateKey) {
        this.validate(this.pkcs11.GenerateKeyPair(session, mechanism, publicKeyTemplate, privateKeyTemplate, publicKey, privateKey));
    }

    public void C_GetAttributeValue(long sh, long objectHandle, CK_ATTRIBUTE[] templ) {
        this.validate(this.pkcs11.GetAttributeValue(sh, objectHandle, templ));
    }

    public void C_SetAttributeValue(long sh, long objectHandle, CK_ATTRIBUTE[] templ) {
        this.validate(this.pkcs11.SetAttributeValue(sh, objectHandle, templ));
    }

    public void C_DestroyObject(long sh, long objectHandle) {
        this.validate(this.pkcs11.DestroyObject(sh, objectHandle));
    }

    public long[] GetSlotList(boolean tokenPresent) {
        LongRef count = new LongRef();
        try {
            this.validate(this.pkcs11.GetSlotList(tokenPresent, null, count));
        }
        catch (PKCS11Exception e) {
            if (e.errorCode == 5L) {
                this.sleep(2);
                this.validate(this.pkcs11.GetSlotList(tokenPresent, null, count));
            }
            throw e;
        }
        long[] slots = new long[(int)count.value];
        if (count.value > 0L) {
            try {
                this.validate(this.pkcs11.GetSlotList(tokenPresent, slots, count));
            }
            catch (PKCS11Exception e) {
                if (e.errorCode == 5L) {
                    this.sleep(2);
                    this.validate(this.pkcs11.GetSlotList(tokenPresent, slots, count));
                }
                throw e;
            }
        }
        return slots;
    }

    private void sleep(int seconds) {
        try {
            TimeUnit.SECONDS.sleep(seconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public long validate(long result) throws PKCS11Exception {
        if (0L != result) {
            throw new PKCS11Exception(result);
        }
        return result;
    }

    public long validate(Function<PKCS11Impl, Long> action) throws PKCS11Exception {
        long result = this.validate(action.apply(this.pkcs11));
        if (0L != result) {
            throw new PKCS11Exception(result);
        }
        return result;
    }

    public synchronized long[] findCertificates(long sessionHandle) throws PKCS11Exception {
        long[] availableCert = null;
        try (LockerImpl lock = this.locker();){
            CK_ATTRIBUTE[] pTemplate = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 1L)};
            this.C_FindObjectsInit(sessionHandle, pTemplate);
            availableCert = this.C_FindObjects(sessionHandle, 100);
            this.C_FindObjectsFinal(sessionHandle);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return availableCert;
    }

    private LockerImpl locker() {
        return LockerImpl.lock((String)new File(this.dllModule).getName());
    }

    public long[] findPrivateKeys(long sessionHandle) throws PKCS11Exception {
        long[] objects = null;
        CK_ATTRIBUTE[] pTemplate = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(1L, true)};
        this.C_FindObjectsInit(sessionHandle, pTemplate);
        objects = this.C_FindObjects(sessionHandle, 100);
        this.C_FindObjectsFinal(sessionHandle);
        return objects;
    }

    public long[] findPublicKeys(long sessionHandle) throws PKCS11Exception {
        long[] objects = null;
        CK_ATTRIBUTE[] pTemplate = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(1L, true)};
        this.C_FindObjectsInit(sessionHandle, pTemplate);
        objects = this.C_FindObjects(sessionHandle, 100);
        this.C_FindObjectsFinal(sessionHandle);
        return objects;
    }

    public String getObjectLabel(long sessionHandle, long objectId) {
        CK_ATTRIBUTE label = new CK_ATTRIBUTE(3L);
        CK_ATTRIBUTE[] aliasTemplate = new CK_ATTRIBUTE[]{label};
        this.C_GetAttributeValue(sessionHandle, objectId, aliasTemplate);
        return label.getValueStr();
    }

    public String getObjectId(long sessionHandle, long objectId) {
        CK_ATTRIBUTE id = new CK_ATTRIBUTE(258L);
        CK_ATTRIBUTE[] aliasTemplate = new CK_ATTRIBUTE[]{id};
        this.C_GetAttributeValue(sessionHandle, objectId, aliasTemplate);
        return id.getValueStr();
    }

    public X509Certificate getCertificate(long sessionHandle, long certId) {
        CK_ATTRIBUTE value = new CK_ATTRIBUTE(17L);
        CK_ATTRIBUTE[] template = new CK_ATTRIBUTE[]{value};
        this.C_GetAttributeValue(sessionHandle, certId, template);
        if (value.getValue() == null || value.getValue().length == 0) {
            throw new PKCS11Exception(19L);
        }
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X509");
            return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(value.getValue()));
        }
        catch (CertificateException e) {
            throw new PKCS11Exception(32L, (Throwable)e);
        }
    }

    public Long findPublicKey(long sessionHandle, byte[] id) {
        return this.findObject(sessionHandle, new CK_ATTRIBUTE(258L, id), 2L);
    }

    public Long findPrivateKey(long sessionHandle, byte[] id) {
        return this.findObject(sessionHandle, new CK_ATTRIBUTE(258L, id), 3L);
    }

    public Long findCertificate(long sessionHandle, String alias) {
        return this.findObject(sessionHandle, new CK_ATTRIBUTE(3L, alias), 1L);
    }

    private Long findObject(long sessionHandle, CK_ATTRIBUTE attr, long type) {
        long[] objects = null;
        CK_ATTRIBUTE[] pTemplate = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, type), attr};
        this.C_FindObjectsInit(sessionHandle, pTemplate);
        objects = this.C_FindObjects(sessionHandle, 10);
        this.C_FindObjectsFinal(sessionHandle);
        if (objects != null && objects.length > 0) {
            return objects[0];
        }
        return null;
    }

    public void readKey(long sessionHandle, long privateKeyId, CK_ATTRIBUTE[] attributes) {
        this.C_GetAttributeValue(sessionHandle, privateKeyId, attributes);
    }

    public long[] GetMechanismList(long slot) {
        LongRef count = new LongRef();
        this.validate(this.pkcs11.GetMechanismList(slot, null, count));
        long[] list = new long[(int)count.value];
        this.validate(this.pkcs11.GetMechanismList(slot, list, count));
        for (long m : list) {
            CK_MECHANISM_INFO info = new CK_MECHANISM_INFO();
            this.validate(this.pkcs11.GetMechanismInfo(slot, m, info));
        }
        return list;
    }

    public void changePIN(long slot, String oldPIN, String newPIN) throws PKCS11Exception {
        this.initialize();
        CK_TOKEN_INFO tokenInfo = this.getTokenInfo(slot);
        if ((tokenInfo.getFlags() & 4L) != 0L) {
            this.session(slot, session -> {
                if ((tokenInfo.getFlags() & 0x100L) != 0L) {
                    this.C_Login(null, 1L, session);
                    this.validate(this.pkcs11.SetPIN(session, null, null));
                } else {
                    this.C_Login(oldPIN, 1L, session);
                    this.validate(this.pkcs11.SetPIN(session, oldPIN.getBytes(), newPIN.getBytes()));
                }
                return true;
            });
        }
    }

    public CK_TOKEN_INFO getTokenInfo(long slot) {
        CK_TOKEN_INFO tokenInfo;
        block4: {
            tokenInfo = new CK_TOKEN_INFO();
            try {
                this.validate(this.pkcs11.GetTokenInfo(slot, tokenInfo));
            }
            catch (PKCS11Exception e) {
                if (e.errorCode != 48L) break block4;
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.validate(this.pkcs11.GetTokenInfo(slot, tokenInfo));
            }
        }
        return tokenInfo;
    }

    public boolean unlockPIN(long slot, String puk, String pin) {
        return this.session(slot, session -> {
            this.C_Login(puk, 0L, session);
            this.validate(this.pkcs11.InitPIN(session, pin.getBytes()));
            this.C_Logout(session);
            this.C_Login(pin, 1L, session);
            this.C_Logout(session);
            return true;
        });
    }

    private void C_Logout(Long session) {
        this.validate(this.pkcs11.Logout(session));
    }

    public void initToken(long slot, String manufPIN, String soPINman, String soPINdef, String defLabel) throws PKCS11Exception {
        this.initialize();
        this.validate(c -> c.CloseAllSessions(slot));
        this.validate(c -> c.InitToken(slot, manufPIN.getBytes(), defLabel.getBytes()));
        log.info("C_InitToken OK");
        this.session(slot, session -> {
            log.info("OpenSession OK");
            this.C_Login(soPINman, 0L, session);
            log.info("C_Login CKU_SO OK");
            this.validate(c -> c.SetPIN(session, soPINman.getBytes(), soPINdef.getBytes()));
            log.info("C_SetPIN OK");
            this.C_Logout(session);
            log.info("C_Logout OK");
            this.C_Login(soPINdef, 0L, session);
            log.info("C_Login CKU_SO OK");
            this.C_Logout(session);
            log.info("C_Logout OK");
            return true;
        });
    }

    public byte[] generateSecretKey(long slot, int byteLength) {
        try {
            return this.session(slot, session -> {
                byte[] random = new byte[byteLength];
                this.pkcs11.GenerateRandom(session, random);
                return random;
            });
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R session(long slot, LongFunction<R> action) {
        long flags = 0L;
        flags |= 4L;
        long session = this.C_OpenSession(slot, flags |= 2L);
        try {
            R r = action.apply(session);
            return r;
        }
        finally {
            this.C_CloseSession(session);
        }
    }

    public CK_SLOT_INFO getSlotInfo(long slot) {
        CK_SLOT_INFO info = new CK_SLOT_INFO();
        this.validate(c -> c.GetSlotInfo(slot, info));
        return info;
    }

    public CK_SESSION_INFO getSessionInfo(long sessionID) {
        CK_SESSION_INFO info = new CK_SESSION_INFO();
        this.validate(c -> c.GetSessionInfo(sessionID, info));
        return info;
    }
}

