/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs11.jna;

import com.anf.pkcs11.jna.CK_TOKEN_INFO;
import com.anf.pkcs11.jna.JNA_CK_VERSION;
import com.sun.jna.NativeLong;
import com.sun.jna.Structure;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class JNA_CK_TOKEN_INFO
extends Structure {
    public byte[] label;
    public byte[] manufacturerID;
    public byte[] model;
    public byte[] serialNumber;
    public NativeLong flags;
    public NativeLong ulMaxSessionCount;
    public NativeLong ulSessionCount;
    public NativeLong ulMaxRwSessionCount;
    public NativeLong ulRwSessionCount;
    public NativeLong ulMaxPinLen;
    public NativeLong ulMinPinLen;
    public NativeLong ulTotalPublicMemory;
    public NativeLong ulFreePublicMemory;
    public NativeLong ulTotalPrivateMemory;
    public NativeLong ulFreePrivateMemory;
    public JNA_CK_VERSION hardwareVersion;
    public JNA_CK_VERSION firmwareVersion;
    public byte[] utcTime;

    public JNA_CK_TOKEN_INFO readFrom(CK_TOKEN_INFO info) {
        this.label = info.getLabel();
        this.manufacturerID = info.getManufacturerID();
        this.model = info.getModel();
        this.serialNumber = info.getSerialNumber();
        this.flags = new NativeLong(info.getFlags());
        this.ulMaxSessionCount = new NativeLong(info.getUlMaxSessionCount());
        this.ulSessionCount = new NativeLong(info.getUlSessionCount());
        this.ulMaxRwSessionCount = new NativeLong(info.getUlMaxRwSessionCount());
        this.ulRwSessionCount = new NativeLong(info.getUlRwSessionCount());
        this.ulMaxPinLen = new NativeLong(info.getUlMaxPinLen());
        this.ulMinPinLen = new NativeLong(info.getUlMinPinLen());
        this.ulTotalPublicMemory = new NativeLong(info.getUlTotalPublicMemory());
        this.ulFreePublicMemory = new NativeLong(info.getUlFreePublicMemory());
        this.ulTotalPrivateMemory = new NativeLong(info.getUlTotalPrivateMemory());
        this.ulFreePrivateMemory = new NativeLong(info.getUlFreePrivateMemory());
        this.hardwareVersion = new JNA_CK_VERSION().readFrom(info.getHardwareVersion());
        this.firmwareVersion = new JNA_CK_VERSION().readFrom(info.getFirmwareVersion());
        this.utcTime = info.getUtcTime();
        return this;
    }

    public CK_TOKEN_INFO writeTo(CK_TOKEN_INFO info) {
        info.setLabel(this.label);
        info.setManufacturerID(this.manufacturerID);
        info.setModel(this.model);
        info.setSerialNumber(this.serialNumber);
        info.setFlags(this.flags.intValue());
        info.setUlMaxSessionCount(this.ulMaxSessionCount.intValue());
        info.setUlSessionCount(this.ulSessionCount.intValue());
        info.setUlMaxRwSessionCount(this.ulMaxRwSessionCount.intValue());
        info.setUlRwSessionCount(this.ulRwSessionCount.intValue());
        info.setUlMaxPinLen(this.ulMaxPinLen.intValue());
        info.setUlMinPinLen(this.ulMinPinLen.intValue());
        info.setUlTotalPublicMemory(this.ulTotalPublicMemory.intValue());
        info.setUlFreePublicMemory(this.ulFreePublicMemory.intValue());
        info.setUlTotalPrivateMemory(this.ulTotalPrivateMemory.intValue());
        info.setUlFreePrivateMemory(this.ulFreePrivateMemory.intValue());
        this.hardwareVersion.writeTo(info.getHardwareVersion());
        this.firmwareVersion.writeTo(info.getFirmwareVersion());
        info.setUtcTime(this.utcTime);
        return info;
    }

    protected List getFieldOrder() {
        ArrayList<String> flist = new ArrayList<String>();
        Class<?> cls = ((Object)((Object)this)).getClass();
        Field[] fields = cls.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            int modifiers = fields[i].getModifiers();
            if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            flist.add(fields[i].getName());
        }
        return flist;
    }
}

