/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs11.jna;

public class Hex {
    public static final char[] HEX_DIGITS;
    public static final int[] HEX_S2B;
    public static final char[][] HEX_B2S;

    public static String b2s(byte[] buf) {
        if (buf == null) {
            return null;
        }
        return Hex.b2s(buf, 0, buf.length);
    }

    public static String b2s(byte[] buf, int start, int len) {
        if (buf == null) {
            return null;
        }
        if (start < 0 || start > buf.length) {
            throw new IllegalArgumentException("start index must be between 0 and buf.length [" + buf.length + "].  Got value" + start);
        }
        if (len < 0 || start + len > buf.length) {
            throw new IllegalArgumentException("len must be between 0 and (buf.length - start) [" + buf.length + " - " + start + " = " + (buf.length - start) + "].  Got value " + len);
        }
        char[] cbuf = new char[len * 2];
        for (int i = 0; i < len; ++i) {
            System.arraycopy(HEX_B2S[buf[start + i] & 0xFF], 0, cbuf, i * 2, 2);
        }
        return new String(cbuf);
    }

    public static String i2s(int num) {
        char[] cbuf = new char[8];
        for (int i = 3; i >= 0; --i) {
            System.arraycopy(HEX_B2S[num & 0xFF], 0, cbuf, i * 2, 2);
            num >>>= 8;
        }
        return new String(cbuf);
    }

    public static byte[] s2b(String hex) {
        if (hex == null) {
            return null;
        }
        byte[] buf = new byte[(hex.length() + 1) / 2];
        int tmpbuf = 0;
        int bits = 0;
        int i = 0;
        int j = 0;
        while (i < hex.length()) {
            int c;
            if ((c = HEX_S2B[hex.charAt(i++) & 0xFF]) < 0) continue;
            tmpbuf |= c;
            if ((bits += 4) == 8) {
                buf[j++] = (byte)tmpbuf;
                bits = 0;
            }
            tmpbuf <<= 4;
        }
        if (bits > 0) {
            buf[j++] = (byte)tmpbuf;
        }
        if (j == buf.length) {
            return buf;
        }
        byte[] smallbuf = new byte[j];
        System.arraycopy(buf, 0, smallbuf, 0, j);
        return smallbuf;
    }

    public static String dump(byte[] buf) {
        if (buf == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Hex.dump(sb, buf, 0, buf.length, "", 16, false);
        return sb.toString();
    }

    public static void dump(StringBuilder sb, byte[] buf, int start, int len, String indent, int lineLen, boolean lineNum) {
        if (buf == null) {
            if (lineNum) {
                sb.append(Hex.i2s(0)).append(" - ");
            }
            sb.append(indent).append("null");
            return;
        }
        char[] ascii = new char[lineLen];
        int lineOffset = 0;
        int i = start;
        int end = start + len;
        while (i < end) {
            if (lineOffset == 0) {
                if (i > start) {
                    sb.append('\n');
                }
                if (lineNum) {
                    sb.append(Hex.i2s(i - start)).append(" - ");
                }
                sb.append(indent);
            } else if ((lineOffset & 7) == 0) {
                sb.append("- ");
            }
            ascii[lineOffset++] = buf[i] >= 32 && buf[i] <= 126 ? (int)buf[i] : 46;
            sb.append(HEX_B2S[buf[i++] & 0xFF]).append(' ');
            if (lineOffset != ascii.length) continue;
            sb.append("  ").append(ascii);
            lineOffset = 0;
        }
        if (lineOffset == 0) {
            return;
        }
        int missingHex = ascii.length - lineOffset;
        int fillLen = missingHex * 3 + missingHex / 8 * 2 + 2;
        while (fillLen-- > 0) {
            sb.append(' ');
        }
        sb.append(ascii, 0, lineOffset);
    }

    static {
        int i;
        HEX_DIGITS = "0123456789abcdef".toCharArray();
        HEX_S2B = new int[256];
        HEX_B2S = new char[256][];
        for (i = 0; i < HEX_S2B.length; ++i) {
            Hex.HEX_S2B[i] = -1;
        }
        for (i = 48; i <= 57; ++i) {
            Hex.HEX_S2B[i] = i - 48;
        }
        for (i = 65; i <= 70; ++i) {
            Hex.HEX_S2B[i] = i - 65 + 10;
        }
        for (i = 97; i <= 102; ++i) {
            Hex.HEX_S2B[i] = i - 97 + 10;
        }
        for (i = 0; i < HEX_DIGITS.length; ++i) {
            for (int j = 0; j < HEX_DIGITS.length; ++j) {
                Hex.HEX_B2S[i * 16 + j] = new char[]{HEX_DIGITS[i], HEX_DIGITS[j]};
            }
        }
    }
}

