/*
 * Decompiled with CFR 0.152.
 */
package com.anf.pkcs11.jna;

import com.anf.pkcs11.jna.Buf;
import com.anf.pkcs11.jna.CKM;
import com.anf.pkcs11.jna.CKRException;
import com.anf.pkcs11.jna.CK_ATTRIBUTE;
import com.anf.pkcs11.jna.CK_INFO;
import com.anf.pkcs11.jna.CK_MECHANISM_INFO;
import com.anf.pkcs11.jna.CK_NOTIFY;
import com.anf.pkcs11.jna.CK_SESSION_INFO;
import com.anf.pkcs11.jna.CK_SLOT_INFO;
import com.anf.pkcs11.jna.CK_TOKEN_INFO;
import com.anf.pkcs11.jna.LongRef;
import com.anf.pkcs11.jna.NativePointer;
import com.anf.pkcs11.jna.PKCS11Impl;

public class CE {
    PKCS11Impl c;

    public void Initialize() {
        long rv = this.c.Initialize();
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void Finalize() {
        long rv = this.c.Finalize();
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void GetInfo(CK_INFO info) {
        long rv = this.c.GetInfo(info);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public CK_INFO GetInfo() {
        CK_INFO info = new CK_INFO();
        this.GetInfo(info);
        return info;
    }

    public void GetSlotList(boolean tokenPresent, long[] slotList, LongRef count) {
        long rv = this.c.GetSlotList(tokenPresent, slotList, count);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public long[] GetSlotList(boolean tokenPresent) {
        LongRef count = new LongRef();
        this.GetSlotList(tokenPresent, null, count);
        long[] result = new long[(int)count.value()];
        this.GetSlotList(tokenPresent, result, count);
        return result;
    }

    public long GetSlot(String label) {
        long[] allslots;
        for (long slot : allslots = this.GetSlotList(true)) {
            CK_TOKEN_INFO tok = this.GetTokenInfo(slot);
            if (tok == null || tok.getLabel() == null || !new String(tok.getLabel()).trim().equals(label)) continue;
            return slot;
        }
        throw new CKRException("No slot found with label [" + label + "]", 3L);
    }

    public void GetSlotInfo(long slotID, CK_SLOT_INFO info) {
        long rv = this.c.GetSlotInfo(slotID, info);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public CK_SLOT_INFO GetSlotInfo(long slotID) {
        CK_SLOT_INFO info = new CK_SLOT_INFO();
        this.GetSlotInfo(slotID, info);
        return info;
    }

    public void GetTokenInfo(long slotID, CK_TOKEN_INFO info) {
        long rv = this.c.GetTokenInfo(slotID, info);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public CK_TOKEN_INFO GetTokenInfo(long slotID) {
        CK_TOKEN_INFO info = new CK_TOKEN_INFO();
        this.GetTokenInfo(slotID, info);
        return info;
    }

    public void GetMechanismList(long slotID, long[] mechanismList, LongRef count) {
        long rv = this.c.GetMechanismList(slotID, mechanismList, count);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public long[] GetMechanismList(long slotID) {
        LongRef count = new LongRef();
        this.GetMechanismList(slotID, null, count);
        long[] mechanisms = new long[(int)count.value()];
        this.GetMechanismList(slotID, mechanisms, count);
        return mechanisms;
    }

    public void GetMechanismInfo(long slotID, long type, CK_MECHANISM_INFO info) {
        long rv = this.c.GetMechanismInfo(slotID, type, info);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public CK_MECHANISM_INFO GetMechanismInfo(long slotID, long type) {
        CK_MECHANISM_INFO info = new CK_MECHANISM_INFO();
        this.GetMechanismInfo(slotID, type, info);
        return info;
    }

    public void InitToken(long slotID, byte[] pin, byte[] label) {
        long rv = this.c.InitToken(slotID, pin, label);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void InitPIN(long session, byte[] pin) {
        long rv = this.c.InitPIN(session, pin);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void SetPIN(long session, byte[] oldPin, byte[] newPin) {
        long rv = this.c.SetPIN(session, oldPin, newPin);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void OpenSession(long slotID, long flags, NativePointer application, CK_NOTIFY notify, LongRef session) {
        long rv = this.c.OpenSession(slotID, flags, application, notify, session);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public long OpenSession(long slotID, long flags, NativePointer application, CK_NOTIFY notify) {
        LongRef session = new LongRef();
        this.OpenSession(slotID, flags, application, notify, session);
        return session.value();
    }

    public long OpenSession(long slotID) {
        return this.OpenSession(slotID, 2L, null, null);
    }

    public void CloseSession(long session) {
        long rv = this.c.CloseSession(session);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void CloseAllSessions(long slotID) {
        long rv = this.c.CloseAllSessions(slotID);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void GetSessionInfo(long session, CK_SESSION_INFO info) {
        long rv = this.c.GetSessionInfo(session, info);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public CK_SESSION_INFO GetSessionInfo(long session) {
        CK_SESSION_INFO info = new CK_SESSION_INFO();
        this.GetSessionInfo(session);
        return info;
    }

    public void GetOperationState(long session, byte[] operationState, LongRef operationStateLen) {
        long rv = this.c.GetOperationState(session, operationState, operationStateLen);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public byte[] GetOperationState(long session) {
        LongRef len = new LongRef();
        this.GetOperationState(session, null, len);
        byte[] result = new byte[(int)len.value()];
        this.GetOperationState(session, result, len);
        return this.resize(result, (int)len.value());
    }

    public void SetOperationState(long session, byte[] operationState, long encryptionKey, long authenticationKey) {
        long rv = this.c.SetOperationState(session, operationState, encryptionKey, authenticationKey);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void Login(long session, long userType, byte[] pin) {
        long rv = this.c.Login(session, userType, pin);
        if (rv != 0L && rv != 256L) {
            throw new CKRException(rv);
        }
    }

    public void LoginUser(long session, byte[] pin) {
        this.Login(session, 1L, pin);
    }

    public void LoginUser(long session, String pin) {
        this.LoginUser(session, Buf.c2b(pin));
    }

    public void LoginSO(long session, byte[] pin) {
        this.Login(session, 0L, pin);
    }

    public void LoginSO(long session, String pin) {
        this.LoginSO(session, Buf.c2b(pin));
    }

    public void Logout(long session) {
        long rv = this.c.Logout(session);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void CreateObject(long session, CK_ATTRIBUTE[] templ, LongRef object) {
        long rv = this.c.CreateObject(session, templ, object);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public long CreateObject(long session, CK_ATTRIBUTE ... templ) {
        LongRef object = new LongRef();
        this.CreateObject(session, templ, object);
        return object.value();
    }

    public void CopyObject(long session, long object, CK_ATTRIBUTE[] templ, LongRef newObject) {
        long rv = this.c.CopyObject(session, object, templ, newObject);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public long CopyObject(long session, long object, CK_ATTRIBUTE ... templ) {
        LongRef newObject = new LongRef();
        this.CopyObject(session, object, templ, newObject);
        return newObject.value();
    }

    public void DestroyObject(long session, long object) {
        long rv = this.c.DestroyObject(session, object);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void GetObjectSize(long session, long object, LongRef size) {
        long rv = this.c.GetObjectSize(session, object, size);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public long GetObjectSize(long session, long object) {
        LongRef size = new LongRef();
        this.GetObjectSize(session, object, size);
        return size.value();
    }

    public void GetAttributeValue(long session, long object, CK_ATTRIBUTE ... templ) {
        if (templ == null || templ.length == 0) {
            return;
        }
        long rv = this.c.GetAttributeValue(session, object, templ);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public CK_ATTRIBUTE GetAttributeValue(long session, long object, long cka) {
        CK_ATTRIBUTE[] templ = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(cka)};
        long rv = this.c.GetAttributeValue(session, object, templ);
        if (rv == 18L || templ[0].ulValueLen == 0L) {
            return templ[0];
        }
        if (rv != 0L) {
            throw new CKRException(rv);
        }
        templ[0].pValue = new byte[(int)templ[0].ulValueLen];
        rv = this.c.GetAttributeValue(session, object, templ);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
        return templ[0];
    }

    public CK_ATTRIBUTE[] GetAttributeValue(long session, long object, long ... types) {
        if (types == null || types.length == 0) {
            return new CK_ATTRIBUTE[0];
        }
        CK_ATTRIBUTE[] templ = new CK_ATTRIBUTE[types.length];
        for (int i = 0; i < types.length; ++i) {
            templ[i] = new CK_ATTRIBUTE(types[i], null);
        }
        try {
            this.GetAttributeValue(session, object, templ);
            for (CK_ATTRIBUTE att : templ) {
                att.pValue = att.ulValueLen > 0L ? new byte[(int)att.ulValueLen] : null;
            }
            this.GetAttributeValue(session, object, templ);
            return templ;
        }
        catch (CKRException ckre) {
            if (ckre.getCKR() != 18L) {
                throw ckre;
            }
            CK_ATTRIBUTE[] result = new CK_ATTRIBUTE[types.length];
            for (int i = 0; i < types.length; ++i) {
                result[i] = this.GetAttributeValue(session, object, types[i]);
            }
            return result;
        }
    }

    public void SetAttributeValue(long session, long object, CK_ATTRIBUTE ... templ) {
        long rv = this.c.SetAttributeValue(session, object, templ);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void FindObjectsInit(long session, CK_ATTRIBUTE ... templ) {
        long rv = this.c.FindObjectsInit(session, templ);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void FindObjects(long session, long[] found, LongRef objectCount) {
        long rv = this.c.FindObjects(session, found, objectCount);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public long[] FindObjects(long session, int maxObjects) {
        long[] found = new long[maxObjects];
        LongRef len = new LongRef();
        this.FindObjects(session, found, len);
        long count = len.value();
        if (count == (long)maxObjects) {
            return found;
        }
        long[] result = new long[(int)count];
        System.arraycopy(found, 0, result, 0, result.length);
        return result;
    }

    public void FindObjectsFinal(long session) {
        long rv = this.c.FindObjectsFinal(session);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public long[] FindObjects(long session, CK_ATTRIBUTE ... templ) {
        long[] found;
        this.FindObjectsInit(session, templ);
        int maxObjects = 1024;
        long[] result = this.FindObjects(session, maxObjects);
        if (result.length < maxObjects) {
            this.FindObjectsFinal(session);
            return result;
        }
        do {
            found = this.FindObjects(session, maxObjects *= 2);
            long[] temp = new long[result.length + found.length];
            System.arraycopy(result, 0, temp, 0, result.length);
            System.arraycopy(found, 0, temp, result.length, found.length);
            result = temp;
        } while (found.length >= maxObjects);
        this.FindObjectsFinal(session);
        return result;
    }

    public void EncryptInit(long session, CKM mechanism, long key) {
        long rv = this.c.EncryptInit(session, mechanism, key);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void Encrypt(long session, byte[] data, byte[] encryptedData, LongRef encryptedDataLen) {
        long rv = this.c.Encrypt(session, data, encryptedData, encryptedDataLen);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public byte[] EncryptPad(long session, byte[] data) {
        LongRef l = new LongRef();
        this.Encrypt(session, data, null, l);
        byte[] result = new byte[(int)l.value()];
        this.Encrypt(session, data, result, l);
        return this.resize(result, (int)l.value());
    }

    public byte[] Encrypt(long session, byte[] data) {
        byte[] result = new byte[data.length];
        LongRef l = new LongRef(result.length);
        this.Encrypt(session, data, result, l);
        return this.resize(result, (int)l.value);
    }

    public void EncryptUpdate(long session, byte[] part, byte[] encryptedPart, LongRef encryptedPartLen) {
        long rv = this.c.EncryptUpdate(session, part, encryptedPart, encryptedPartLen);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public byte[] EncryptUpdate(long session, byte[] part) {
        LongRef l = new LongRef();
        this.EncryptUpdate(session, part, null, l);
        byte[] result = new byte[(int)l.value()];
        this.EncryptUpdate(session, part, result, l);
        return this.resize(result, (int)l.value());
    }

    public void EncryptFinal(long session, byte[] lastEncryptedPart, LongRef lastEncryptedPartLen) {
        long rv = this.c.EncryptFinal(session, lastEncryptedPart, lastEncryptedPartLen);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public byte[] EncryptFinal(long session) {
        LongRef l = new LongRef();
        this.EncryptFinal(session, null, l);
        byte[] result = new byte[(int)l.value()];
        this.EncryptFinal(session, result, l);
        return this.resize(result, (int)l.value());
    }

    public byte[] EncryptPad(long session, CKM mechanism, long key, byte[] data) {
        this.EncryptInit(session, mechanism, key);
        return this.EncryptPad(session, data);
    }

    public byte[] Encrypt(long session, CKM mechanism, long key, byte[] data) {
        this.EncryptInit(session, mechanism, key);
        return this.Encrypt(session, data);
    }

    public void DecryptInit(long session, CKM mechanism, long key) {
        long rv = this.c.DecryptInit(session, mechanism, key);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void Decrypt(long session, byte[] encryptedData, byte[] data, LongRef dataLen) {
        long rv = this.c.Decrypt(session, encryptedData, data, dataLen);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public byte[] DecryptPad(long session, byte[] encryptedData) {
        LongRef l = new LongRef();
        this.Decrypt(session, encryptedData, null, l);
        byte[] result = new byte[(int)l.value()];
        this.Decrypt(session, encryptedData, result, l);
        return this.resize(result, (int)l.value());
    }

    public byte[] Decrypt(long session, byte[] encryptedData) {
        byte[] result = new byte[encryptedData.length];
        LongRef l = new LongRef(result.length);
        this.Decrypt(session, encryptedData, result, l);
        return this.resize(result, (int)l.value());
    }

    public void DecryptUpdate(long session, byte[] encryptedPart, byte[] data, LongRef dataLen) {
        long rv = this.c.DecryptUpdate(session, encryptedPart, data, dataLen);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public byte[] DecryptUpdate(long session, byte[] encryptedPart) {
        LongRef l = new LongRef();
        this.DecryptUpdate(session, encryptedPart, null, l);
        byte[] result = new byte[(int)l.value()];
        this.DecryptUpdate(session, encryptedPart, result, l);
        return this.resize(result, (int)l.value());
    }

    public void DecryptFinal(long session, byte[] lastPart, LongRef lastPartLen) {
        long rv = this.c.DecryptFinal(session, lastPart, lastPartLen);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public byte[] DecryptFinal(long session) {
        LongRef l = new LongRef();
        this.DecryptFinal(session, null, l);
        byte[] result = new byte[(int)l.value()];
        this.DecryptFinal(session, result, l);
        return this.resize(result, (int)l.value());
    }

    public byte[] DecryptPad(long session, CKM mechanism, long key, byte[] encryptedData) {
        this.DecryptInit(session, mechanism, key);
        return this.DecryptPad(session, encryptedData);
    }

    public byte[] Decrypt(long session, CKM mechanism, long key, byte[] encryptedData) {
        this.DecryptInit(session, mechanism, key);
        return this.Decrypt(session, encryptedData);
    }

    public void DigestInit(long session, CKM mechanism) {
        long rv = this.c.DigestInit(session, mechanism);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void Digest(long session, byte[] data, byte[] digest, LongRef digestLen) {
        long rv = this.c.Digest(session, data, digest, digestLen);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public byte[] Digest(long session, byte[] data) {
        LongRef l = new LongRef();
        this.Digest(session, data, null, l);
        byte[] result = new byte[(int)l.value()];
        this.Digest(session, data, result, l);
        return this.resize(result, (int)l.value());
    }

    public void DigestUpdate(long session, byte[] part) {
        long rv = this.c.DigestUpdate(session, part);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void DigestKey(long session, long key) {
        long rv = this.c.DigestKey(session, key);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void DigestFinal(long session, byte[] digest, LongRef digestLen) {
        long rv = this.c.DigestFinal(session, digest, digestLen);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public byte[] DigestFinal(long session) {
        LongRef l = new LongRef();
        this.DigestFinal(session, null, l);
        byte[] result = new byte[(int)l.value()];
        this.DigestFinal(session, result, l);
        return this.resize(result, (int)l.value());
    }

    public byte[] Digest(long session, CKM mechanism, byte[] data) {
        this.DigestInit(session, mechanism);
        return this.Digest(session, data);
    }

    public void SignInit(long session, CKM mechanism, long key) {
        long rv = this.c.SignInit(session, mechanism, key);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void Sign(long session, byte[] data, byte[] signature, LongRef signatureLen) {
        long rv = this.c.Sign(session, data, signature, signatureLen);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public byte[] Sign(long session, byte[] data) {
        LongRef l = new LongRef();
        this.Sign(session, data, null, l);
        byte[] result = new byte[(int)l.value()];
        this.Sign(session, data, result, l);
        return this.resize(result, (int)l.value());
    }

    public void SignUpdate(long session, byte[] part) {
        long rv = this.c.SignUpdate(session, part);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void SignFinal(long session, byte[] signature, LongRef signatureLen) {
        long rv = this.c.SignFinal(session, signature, signatureLen);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public byte[] SignFinal(long session) {
        LongRef l = new LongRef();
        this.SignFinal(session, null, l);
        byte[] result = new byte[(int)l.value()];
        this.SignFinal(session, result, l);
        return this.resize(result, (int)l.value());
    }

    public byte[] Sign(long session, CKM mechanism, long key, byte[] data) {
        this.SignInit(session, mechanism, key);
        return this.Sign(session, data);
    }

    public void SignRecoverInit(long session, CKM mechanism, long key) {
        long rv = this.c.SignRecoverInit(session, mechanism, key);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void SignRecover(long session, byte[] data, byte[] signature, LongRef signatureLen) {
        long rv = this.c.SignRecover(session, data, signature, signatureLen);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public byte[] SignRecover(long session, byte[] data) {
        LongRef l = new LongRef();
        this.SignRecover(session, data, null, l);
        byte[] result = new byte[(int)l.value()];
        this.SignRecover(session, data, result, l);
        return this.resize(result, (int)l.value());
    }

    public byte[] SignRecover(long session, CKM mechanism, long key, byte[] data) {
        this.SignRecoverInit(session, mechanism, key);
        return this.SignRecover(session, data);
    }

    public void VerifyInit(long session, CKM mechanism, long key) {
        long rv = this.c.VerifyInit(session, mechanism, key);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void Verify(long session, byte[] data, byte[] signature) {
        long rv = this.c.Verify(session, data, signature);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void VerifyUpdate(long session, byte[] part) {
        long rv = this.c.VerifyUpdate(session, part);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void VerifyFinal(long session, byte[] signature) {
        long rv = this.c.VerifyFinal(session, signature);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void Verify(long session, CKM mechanism, long key, byte[] data, byte[] signature) {
        this.VerifyInit(session, mechanism, key);
        this.Verify(session, data, signature);
    }

    public void VerifyRecoverInit(long session, CKM mechanism, long key) {
        long rv = this.c.VerifyRecoverInit(session, mechanism, key);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void VerifyRecover(long session, byte[] signature, byte[] data, LongRef dataLen) {
        long rv = this.c.VerifyRecover(session, signature, data, dataLen);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public byte[] VerifyRecover(long session, byte[] signature) {
        LongRef l = new LongRef();
        this.VerifyRecover(session, signature, null, l);
        byte[] result = new byte[(int)l.value()];
        this.VerifyRecover(session, signature, result, l);
        return this.resize(result, (int)l.value());
    }

    public byte[] VerifyRecover(long session, CKM mechanism, long key, byte[] signature) {
        this.VerifyRecoverInit(session, mechanism, key);
        return this.VerifyRecover(session, signature);
    }

    public void DigestEncryptUpdate(long session, byte[] part, byte[] encryptedPart, LongRef encryptedPartLen) {
        long rv = this.c.DigestEncryptUpdate(session, part, encryptedPart, encryptedPartLen);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public byte[] DigestEncryptUpdate(long session, byte[] part) {
        LongRef l = new LongRef();
        this.DigestEncryptUpdate(session, part, null, l);
        byte[] result = new byte[(int)l.value()];
        this.DigestEncryptUpdate(session, part, result, l);
        return this.resize(result, (int)l.value());
    }

    public void DecryptDigestUpdate(long session, byte[] encryptedPart, byte[] part, LongRef partLen) {
        long rv = this.c.DecryptDigestUpdate(session, encryptedPart, part, partLen);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public byte[] DecryptDigestUpdate(long session, byte[] encryptedPart) {
        LongRef l = new LongRef();
        this.DecryptDigestUpdate(session, encryptedPart, null, l);
        byte[] result = new byte[(int)l.value()];
        this.DecryptDigestUpdate(session, encryptedPart, result, l);
        return this.resize(result, (int)l.value());
    }

    public void SignEncryptUpdate(long session, byte[] part, byte[] encryptedPart, LongRef encryptedPartLen) {
        long rv = this.c.SignEncryptUpdate(session, part, encryptedPart, encryptedPartLen);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public byte[] SignEncryptUpdate(long session, byte[] part) {
        LongRef l = new LongRef();
        this.SignEncryptUpdate(session, part, null, l);
        byte[] result = new byte[(int)l.value()];
        this.SignEncryptUpdate(session, part, result, l);
        return this.resize(result, (int)l.value());
    }

    public void DecryptVerifyUpdate(long session, byte[] encryptedPart, byte[] part, LongRef partLen) {
        long rv = this.c.DecryptVerifyUpdate(session, encryptedPart, part, partLen);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public byte[] DecryptVerifyUpdate(long session, byte[] encryptedPart) {
        LongRef l = new LongRef();
        this.DecryptVerifyUpdate(session, encryptedPart, null, l);
        byte[] result = new byte[(int)l.value()];
        this.DecryptVerifyUpdate(session, encryptedPart, result, l);
        return this.resize(result, (int)l.value());
    }

    public void GenerateKey(long session, CKM mechanism, CK_ATTRIBUTE[] templ, LongRef key) {
        long rv = this.c.GenerateKey(session, mechanism, templ, key);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public long GenerateKey(long session, CKM mechanism, CK_ATTRIBUTE ... templ) {
        LongRef key = new LongRef();
        this.GenerateKey(session, mechanism, templ, key);
        return key.value();
    }

    public void GenerateKeyPair(long session, CKM mechanism, CK_ATTRIBUTE[] publicKeyTemplate, CK_ATTRIBUTE[] privateKeyTemplate, LongRef publicKey, LongRef privateKey) {
        long rv = this.c.GenerateKeyPair(session, mechanism, publicKeyTemplate, privateKeyTemplate, publicKey, privateKey);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void WrapKey(long session, CKM mechanism, long wrappingKey, long key, byte[] wrappedKey, LongRef wrappedKeyLen) {
        long rv = this.c.WrapKey(session, mechanism, wrappingKey, key, wrappedKey, wrappedKeyLen);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public byte[] WrapKey(long session, CKM mechanism, long wrappingKey, long key) {
        LongRef l = new LongRef();
        this.WrapKey(session, mechanism, wrappingKey, key, null, l);
        byte[] result = new byte[(int)l.value()];
        this.WrapKey(session, mechanism, wrappingKey, key, result, l);
        return this.resize(result, (int)l.value());
    }

    public void UnwrapKey(long session, CKM mechanism, long unwrappingKey, byte[] wrappedKey, CK_ATTRIBUTE[] templ, LongRef key) {
        long rv = this.c.UnwrapKey(session, mechanism, unwrappingKey, wrappedKey, templ, key);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public long UnwrapKey(long session, CKM mechanism, long unwrappingKey, byte[] wrappedKey, CK_ATTRIBUTE ... templ) {
        LongRef result = new LongRef();
        this.UnwrapKey(session, mechanism, unwrappingKey, wrappedKey, templ, result);
        return result.value();
    }

    public void DeriveKey(long session, CKM mechanism, long baseKey, CK_ATTRIBUTE[] templ, LongRef key) {
        long rv = this.c.DeriveKey(session, mechanism, baseKey, templ, key);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public long DeriveKey(long session, CKM mechanism, long baseKey, CK_ATTRIBUTE ... templ) {
        LongRef key = new LongRef();
        this.DeriveKey(session, mechanism, baseKey, templ, key);
        return key.value();
    }

    public void SeedRandom(long session, byte[] seed) {
        long rv = this.c.SeedRandom(session, seed);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void GenerateRandom(long session, byte[] randomData) {
        long rv = this.c.GenerateRandom(session, randomData);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public byte[] GenerateRandom(long session, int randomLen) {
        byte[] result = new byte[randomLen];
        this.GenerateRandom(session, result);
        return result;
    }

    public void GetFunctionStatus(long session) {
        long rv = this.c.GetFunctionStatus(session);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public void CancelFunction(long session) {
        long rv = this.c.CancelFunction(session);
        if (rv != 0L) {
            throw new CKRException(rv);
        }
    }

    public byte[] setOddParity(byte[] buf) {
        int i = 0;
        while (i < buf.length) {
            int b = buf[i] & 0xFF;
            b ^= b >> 4;
            b ^= b >> 2;
            b ^= b >> 1;
            int n = i++;
            buf[n] = (byte)(buf[n] ^ (b & 1 ^ 1));
        }
        return buf;
    }

    public byte[] resize(byte[] buf, int newSize) {
        if (buf == null || newSize >= buf.length) {
            return buf;
        }
        byte[] result = new byte[newSize];
        System.arraycopy(buf, 0, result, 0, result.length);
        return result;
    }
}

