/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.verifier.sources.tsl.model;

import com.anf.cryptotoken.sign.verifier.sources.tsl.model.DateDeserializer;
import com.anf.cryptotoken.sign.verifier.sources.tsl.model.InterfaceSerializer;
import com.anf.cryptotoken.sign.verifier.sources.tsl.model.TrustPropertiesJson;
import com.anf.oauth.json.JSONFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.GsonBuilder;
import eu.europa.esig.dss.model.tsl.Condition;
import eu.europa.esig.dss.model.tsl.TrustProperties;
import eu.europa.esig.dss.tsl.dto.condition.CompositeCondition;
import eu.europa.esig.dss.tsl.dto.condition.PolicyIdCondition;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class TrustPropertiesListJson {
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
    private List<TrustPropertiesJson> properties;

    public TrustPropertiesListJson(List<TrustProperties> props) {
        if (props != null) {
            this.properties = new ArrayList<TrustPropertiesJson>(props.size());
            props.forEach(prop -> this.properties.add(new TrustPropertiesJson((TrustProperties)prop)));
        }
    }

    public TrustPropertiesListJson() {
    }

    public List<TrustPropertiesJson> getProperties() {
        return this.properties;
    }

    public String toJson() throws JsonProcessingException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        JSONFactory.getMapper().setDateFormat((DateFormat)dateFormat);
        JSONFactory.getMapper().disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return JSONFactory.getMapper().writeValueAsString((Object)this);
    }

    public static TrustPropertiesListJson fromJson(String json) throws JsonMappingException, JsonProcessingException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new DateDeserializer("yyyy-MM-dd HH:mm:ssZ"));
        InterfaceSerializer<CompositeCondition> serializer = new InterfaceSerializer<CompositeCondition>(CompositeCondition.class);
        serializer.alias("policyOid", PolicyIdCondition.class);
        gsonBuilder.registerTypeAdapter(Condition.class, serializer);
        gsonBuilder.setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes f) {
                return X509Certificate.class.equals((Object)f.getDeclaredClass());
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return X509Certificate.class.equals(clazz);
            }
        }});
        return (TrustPropertiesListJson)gsonBuilder.create().fromJson(json, TrustPropertiesListJson.class);
    }

    public List<TrustProperties> toList() {
        ArrayList<TrustProperties> properties = new ArrayList<TrustProperties>();
        this.properties.forEach(p -> properties.add(p.toObject()));
        return properties;
    }
}

