/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.verifier.sources.tsl.model;

import com.anf.cryptotoken.sign.verifier.sources.tsl.model.LOTLInfoJson;
import com.anf.cryptotoken.sign.verifier.sources.tsl.model.TLinfoJson;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.timedependent.TimeDependentValues;
import eu.europa.esig.dss.model.tsl.LOTLInfo;
import eu.europa.esig.dss.model.tsl.TLInfo;
import eu.europa.esig.dss.model.tsl.TrustProperties;
import eu.europa.esig.dss.model.tsl.TrustServiceProvider;
import eu.europa.esig.dss.model.tsl.TrustServiceStatusAndInformationExtensions;

public class TrustPropertiesJson {
    private String tlIdentifier;
    private String lotlIdentifier;
    TLinfoJson tlInfo;
    LOTLInfoJson lotlInfo;
    private TrustServiceProvider trustServiceProvider;
    private TimeDependentValues<TrustServiceStatusAndInformationExtensions> trustService;

    public TrustPropertiesJson() {
    }

    public TrustPropertiesJson(TrustProperties trustProperties) {
        this.tlInfo = new TLinfoJson(trustProperties.getTLInfo());
        this.lotlInfo = new LOTLInfoJson(trustProperties.getLOTLInfo());
        this.trustServiceProvider = trustProperties.getTrustServiceProvider();
        this.trustService = trustProperties.getTrustService();
        this.tlIdentifier = trustProperties.getTLInfo().getDSSId().asXmlId();
        this.lotlIdentifier = trustProperties.getLOTLInfo().getDSSId().asXmlId();
    }

    public TrustProperties toObject() {
        return new TrustProperties(this.getLotlInfo(), this.getTlInfo(), this.trustServiceProvider, this.trustService);
    }

    public LOTLInfo getLotlInfo() {
        if (this.lotlInfo == null && this.lotlIdentifier != null) {
            LOTLInfo info = new LOTLInfo(null, null, null, ""){

                public Identifier getDSSId() {
                    return new Identifier("LOTL-", new byte[0]){

                        public String asXmlId() {
                            return TrustPropertiesJson.this.lotlIdentifier;
                        }
                    };
                }
            };
            this.lotlInfo = new LOTLInfoJson(info);
            return info;
        }
        return this.lotlInfo.toObject();
    }

    public TLInfo getTlInfo() {
        if (this.tlInfo == null && this.tlIdentifier != null) {
            TLInfo info = new TLInfo(null, null, null, ""){

                public Identifier getDSSId() {
                    return new Identifier("TL-", new byte[0]){

                        public String asXmlId() {
                            return TrustPropertiesJson.this.tlIdentifier;
                        }
                    };
                }
            };
            this.tlInfo = new TLinfoJson(info);
            return info;
        }
        return this.tlInfo.toObject();
    }
}

